/*-----------------------------------------------------------------
  Bayesian inference of population genetic forces: drift, migraiton, divergence
  allowing for the n-coalescent, the f-coalescent, and the BSC-coalescent
 
  Peter Beerli
  Department of Scientific Computing
  Florida State University
  Tallahassee FL 32306-4120
  beerli@fsu.edu
 
  Copyright 2017 Peter Beerli, Tallahassee FL

 Permission is hereby granted, free of charge, to any person obtaining
 a copy of this software and associated documentation files (the
 "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish,
 distribute, sublicense, and/or sell copies of the Software, and to
 permit persons to whom the Software is furnished to do so, subject
 to the following conditions:
 
 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*-----------------------------------------------------------------
*/
// interpolation table for mittag-leffler function
// global lookup table used in hermite_interpoly.c
//
//
// to interpolate mittagl-leffler in the range of
// for z     = -2000000,-500 .. 500 
// for alpha = 0.01 .. 0.99
// for beta  = 1.0 (lookupa1) and beta=alpha (lookupaa)
//
// this files also delivers the z values that are tabulated.
#include "definitions.h"
#include "mittag_leffler_interpol_data.h"

/** z lookup*/
long nz_lookupaa[NROWS] = {33, 34, 34, 35, 35, 35, 36, 36, 36, 36, 36, 36, 37, 37, 37, 37, 37, 37, 37, 
 37, 37, 37, 37, 37, 37, 37, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 
 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 
			   37, 37, 37, 37};

long nz_lookupa1[NROWS] = {38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 
 38, 38, 38, 38, 38, 38, 38, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 
 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 
			   37, 37, 37, 37};




double z_lookupaa[NROWS][NCOLS] = {{-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., -15625., 
  -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 0., 0
  , 0, 0, 0, 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250.
  , -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625
  , -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125
  , -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, 0., 0, 0, 0, 0}, {-2.e6, -1.e6, -500000., -250000.
  , -125000., -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, 
  -976.5625, -488.28125, -244.140625, -122.0703125, -61.03515625, 
  -30.517578125, -15.2587890625, -7.62939453125, -3.814697265625, 
  -1.9073486328125, -0.95367431640625, -0.476837158203125, -0.2384185791015625
  , -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 0., 
  0, 0, 0, 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, 0., 0, 0, 0}, {-2.e6, 
  -1.e6, -500000., -250000., -125000., -62500., -31250., -15625., -7812.5, 
  -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, -122.0703125, 
  -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, -3.814697265625
  , -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, 0., 0, 0, 0}, {-2.e6, 
  -1.e6, -500000., -250000., -125000., -62500., -31250., -15625., -7812.5, 
  -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, -122.0703125, 
  -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, -3.814697265625
  , -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, 0., 0, 0, 0}, {-2.e6, 
  -1.e6, -500000., -250000., -125000., -62500., -31250., -15625., -7812.5, 
  -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, -122.0703125, 
  -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, -3.814697265625
  , -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  0., 0, 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  0., 0, 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  0., 0, 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  0., 0, 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  0., 0, 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  0., 0, 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, -0.000029103830456733704, 0.}, {-2.e6, -1.e6, 
  -500000., -250000., -125000., -62500., -31250., -15625., -7812.5, -3906.25, 
  -1953.125, -976.5625, -488.28125, -244.140625, -122.0703125, -61.03515625, 
  -30.517578125, -15.2587890625, -7.62939453125, -3.814697265625, 
  -1.9073486328125, -0.95367431640625, -0.476837158203125, -0.2384185791015625
  , -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}}

;

double z_lookupa1[NROWS][NCOLS] = {{-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., -15625., 
  -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, -0.000029103830456733704, 0.}, {-2.e6, -1.e6, 
  -500000., -250000., -125000., -62500., -31250., -15625., -7812.5, -3906.25, 
  -1953.125, -976.5625, -488.28125, -244.140625, -122.0703125, -61.03515625, 
  -30.517578125, -15.2587890625, -7.62939453125, -3.814697265625, 
  -1.9073486328125, -0.95367431640625, -0.476837158203125, -0.2384185791015625
  , -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  -0.000029103830456733704, 0.}, {-2.e6, -1.e6, -500000., -250000., -125000., 
  -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000., -62500., -31250., 
  -15625., -7812.5, -3906.25, -1953.125, -976.5625, -488.28125, -244.140625, 
  -122.0703125, -61.03515625, -30.517578125, -15.2587890625, -7.62939453125, 
  -3.814697265625, -1.9073486328125, -0.95367431640625, -0.476837158203125, 
  -0.2384185791015625, -0.11920928955078125, -0.059604644775390625, 
  -0.029802322387695312, -0.014901161193847656, -0.007450580596923828, 
  -0.003725290298461914, -0.001862645149230957, -0.0009313225746154785, 
  -0.00046566128730773926, -0.00023283064365386963, -0.00011641532182693481, 
  -0.00005820766091346741, 0., 0}, {-2.e6, -1.e6, -500000., -250000., -125000.
  , -62500., -31250., -15625., -7812.5, -3906.25, -1953.125, -976.5625, 
  -488.28125, -244.140625, -122.0703125, -61.03515625, -30.517578125, 
  -15.2587890625, -7.62939453125, -3.814697265625, -1.9073486328125, 
  -0.95367431640625, -0.476837158203125, -0.2384185791015625, 
  -0.11920928955078125, -0.059604644775390625, -0.029802322387695312, 
  -0.014901161193847656, -0.007450580596923828, -0.003725290298461914, 
  -0.001862645149230957, -0.0009313225746154785, -0.00046566128730773926, 
  -0.00023283064365386963, -0.00011641532182693481, -0.00005820766091346741, 
  0., 0}}
;

double mlf_lookupaa[NROWS][NCOLS] = {{-33.62834146379735, -32.24204809667307, -30.855755723542917, 
  -29.46946533839658, -28.083178929200102, -26.696900471832233, 
  -25.31063791783719, -23.924407169450266, -22.53824002772985, 
  -21.152200081146646, -19.766414452079875, -18.381137167215183, 
  -16.99687540903885, -15.614640070195328, -14.236439135772454, 
  -12.866234078802979, -11.51173534226743, -10.187555499991912, 
  -8.919988493216618, -7.75189752277371, -6.741433086175921, 
  -5.944424317088226, -5.382912574478036, -5.029301637166577, 
  -4.825910819894152, -4.715896701578497, -4.658534841517889, 
  -4.629225218380173, -4.614407820651145, -4.606957770402346, 
  -4.603222317480349, -4.601351972707969, -4.599479878042022, 
  -4.599479878042022, -4.599479878042022, -4.599479878042022, 
  -4.599479878042022, -4.599479878042022}, {-32.941216019564514, 
  -31.554922645967988, -30.16863025989337, -28.78233984885818, 
  -27.396053387884333, -26.009774826963113, -24.623512065866883, 
  -23.237280903299652, -21.851112933306858, -20.4650713305318, 
  -19.07928239049217, -17.69399848931967, -16.30972352103493, 
  -14.927461851649811, -13.549208612039385, -12.1789003462055, 
  -10.824200627135458, -9.49963927950086, -8.231382058005266, 
  -7.0621446393769665, -6.050022431687649, -5.251042079638466, 
  -4.687665663384075, -4.3326365821538255, -4.128335343197809, 
  -4.017798424010421, -3.960155313443366, -3.930699665020657, 
  -3.9158078448742537, -3.908320223155274, -3.904565893432904, 
  -3.902686087367576, -3.9017455225902684, -3.900804516098376, 
  -3.900804516098376, -3.900804516098376, -3.900804516098376, 
  -3.900804516098376}, {-32.541942088069035, -31.155648707523266, 
  -29.769356307550176, -28.383065868718145, -26.99677935215101, 
  -25.610500680044773, -24.224237696584773, -22.838006089315044, 
  -21.451837230017432, -20.06579384903334, -18.680001354177232, 
  -17.29471034977148, -15.91042120056638, -14.528131271105238, 
  -13.149821915071344, -11.779403005119706, -10.424488150296987, 
  -9.099519626887194, -7.8305297979002, -6.660087412202047, -5.646250443759286
  , -4.845276430117399, -4.280064283002027, -3.9236744607075957, 
  -3.7185169986627815, -3.607494862484899, -3.5495927347999077, 
  -3.520003170793874, -3.5050432503268403, -3.497521287543795, 
  -3.4937497138933287, -3.4918612674304645, -3.4909163778354135, 
  -3.489971043442412, -3.489971043442412, -3.489971043442412, 
  -3.489971043442412, -3.489971043442412}, {-32.2606232074289, 
  -30.87432981944855, -29.48803740460633, -28.101746936036157, 
  -26.71546035999317, -25.329181568936992, -23.94291834758413, 
  -22.556686264556784, -21.170516453856337, -19.784471170516046, 
  -18.398674872744476, -17.01337626968787, -15.62907195184005, 
  -14.246751799241196, -12.868382449651879, -11.497845333046975, 
  -10.142700951781379, -8.817299168685704, -7.5475337118881365, 
  -6.375827118657325, -5.360217957672626, -4.557228279693252, 
  -3.990209481411042, -3.6325160042785805, -3.4265559034394313, 
  -3.315085572153789, -3.2569462820877133, -3.227234692380712, 
  -3.212212875237748, -3.2046597403084522, -3.2008725242758094, 
  -3.1989762424999553, -3.198027431712354, -3.1975528586606834, 
  -3.1970781737673057, -3.1970781737673057, -3.1970781737673057, 
  -3.1970781737673057}, {-32.04401751105224, -30.657724115143726, 
  -29.27143168444521, -27.885141184162567, -26.498854544695128, 
  -25.112575626791994, -23.72631215175303, -22.340079561384712, 
  -20.953908736127218, -19.567861424172257, -18.182061071168004, 
  -16.79675436562384, -15.412433874642016, -14.030081502581403, 
  -12.651648216868166, -11.280985204446491, -9.92559666894555, 
  -8.599735126563365, -7.329150382720179, -6.1561195897541054, 
  -5.138680320072656, -4.333653035230406, -3.7648568290036386, 
  -3.405916500150502, -3.1992067482754467, -3.0873246876294536, 
  -3.0289697125156656, -2.9991477671991813, -2.9840701384114183, 
  -2.9764889386369724, -2.9726876503651005, -2.9707843225084694, 
  -2.969831986189354, -2.9693556497490423, -2.968879201051731, 
  -2.968879201051731, -2.968879201051731, -2.968879201051731}, {
  -31.86841119622848, -30.482117791890044, -29.09582534433172, 
  -27.709534810329586, -26.323248103423712, -24.936969050645853, 
  -23.550705305866053, -22.164472176050467, -20.77830027203608, 
  -19.392250803117744, -18.006446138387123, -16.62113081818185, 
  -15.236793132965268, -13.854406512155254, -12.475905282832493, 
  -11.105108559547666, -9.749461005368493, -8.423112786084852, 
  -7.1516644448243465, -5.977248676100634, -4.957920853512816, 
  -4.1508340650426785, -3.5802898850680362, -3.2201592566593344, 
  -3.0127522613333646, -2.9004943862904846, -2.841944827274122, 
  -2.8120239767579385, -2.796896502653203, -2.7892902836343754, 
  -2.7854764618114096, -2.783566861225405, -2.782611387056773, 
  -2.782133481320954, -2.7816554630811448, -2.7816554630811448, 
  -2.7816554630811448, -2.7816554630811448}, {-31.721155948412626, 
  -30.334862535134427, -28.94857006969662, -27.56227949993566, 
  -26.17599272151272, -24.789713525703093, -23.403449494869164, 
  -22.017215792982984, -20.63104274497802, -19.244990988680833, 
  -17.8591817516003, -16.473857296315337, -15.089501379331713, 
  -13.707078447854725, -12.328505203100903, -10.957566828862223, 
  -9.601645155446747, -8.274782921170436, -7.002426007871753, 
  -5.82656366947125, -4.805288276710012, -3.996120120187506, 
  -3.423857619914251, -3.062593023975718, -2.8545406276162217, 
  -2.741942307221618, -2.6832188904481122, -2.6532103656491923, 
  -2.63803889383206, -2.6304106394290185, -2.626585791260355, 
  -2.624670675399636, -2.6237124430759815, -2.6232331581342176, 
  -2.622993473445621, -2.6227537606032154, -2.6227537606032154, 
  -2.6227537606032154}, {-31.594703063238974, -30.2084096405032, 
  -28.82211715615027, -27.435826548559234, -26.049539694476785, 
  -24.66326034735069, -23.27699601389407, -21.890761706803463, 
  -20.504587448553448, -19.118533272421153, -17.732719198288898, 
  -16.347385079362233, -14.96300987684477, -13.58054854052295, 
  -12.201899144825347, -10.830811055432394, -9.474599926727368, 
  -8.14719591628284, -6.873884778031274, -5.696513421979253, -4.67323082209786
  , -3.861959453330339, -3.28800853457189, -2.9256661124741905, 
  -2.717019606022705, -2.6041156678086486, -2.5452387455916825, 
  -2.515153558201781, -2.4999438176014386, -2.492296449935399, 
  -2.4884620511388564, -2.4865421615574874, -2.4855815427835193, 
  -2.4851010647205714, -2.4848607834975596, -2.4846204741382616, 
  -2.4846204741382616, -2.4846204741382616}, {-31.484184581725405, 
  -30.097891149006365, -28.711598644686955, -27.32530799716313, 
  -25.93902106321579, -24.552741556362694, -23.166476903463135, 
  -21.780241957530954, -20.394066421774944, -19.00800969133909, 
  -17.622190511431736, -16.236846192269635, -14.852450634433703, 
  -13.469948767235612, -12.091219022100551, -10.719973030276531, 
  -9.36345687543991, -8.035482901804498, -6.761171192372287, 
  -5.582227478306209, -4.556877366560034, -3.7434809506295035, 
  -3.1678717935115905, -2.804507524137046, -2.595317659477648, 
  -2.482142393433646, -2.4231319454086075, -2.3929808882396713, 
  -2.377738489223659, -2.3700748687190463, -2.3662323635422875, 
  -2.364308425901541, -2.3633457843958534, -2.362864295293459, 
  -2.362623508632569, -2.3623826938900474, -2.3623826938900474, 
  -2.3623826938900474}, {-31.386277727661785, -29.999984284426056, 
  -28.613691759073316, -27.227401069483015, -25.841114051403476, 
  -24.45483437628895, -23.06856938687846, -21.682333767972082, 
  -20.296156886458352, -18.9100974652695, -17.524272906904113, 
  -16.13891784300326, -14.75450084428329, -13.371956288768773, 
  -11.993141933499231, -10.62172973002586, -9.264892744221328, 
  -7.936320191597609, -6.660960853793435, -5.480378884273309, 
  -4.451280325917368, -3.6373585656260348, -3.0601216593735265, 
  -2.695791385972301, -2.4861083871156167, -2.3726955492477275, 
  -2.3135711835166317, -2.2833648309230505, -2.268095265474984, 
  -2.2604181909407357, -2.256568992200145, -2.2546417162875105, 
  -2.253677407791986, -2.2531950857335374, -2.2529538827296287, 
  -2.252712651734206, -2.252712651734206, -2.252712651734206}, {
  -31.298613471023057, -29.912320016729605, -28.526027469261468, 
  -27.139736735440575, -25.75344962890064, -24.367169776868522, 
  -22.980904433635622, -21.594668107135504, -20.208489810638582, 
  -18.822427560300287, -17.436597346901777, -16.051230985982126, 
  -14.666791445289357, -13.284202013093687, -11.905298725636266, 
  -10.533711880593096, -9.176538025874738, -7.847337846599025, 
  -6.570883101613314, -5.388600875477097, -4.358931904090011, 
  -3.5412198789679765, -2.9623860535322457, -2.5971455092712854, 
  -2.387019082341621, -2.273401897844963, -2.214182852118722, 
  -2.1839315604955223, -2.168640202454927, -2.16095241120357, 
  -2.1570979003437944, -2.15516798010278, -2.1542023523974994, 
  -2.1537193714754976, -2.1534778392254847, -2.1532362791078685, 
  -2.1532362791078685, -2.1532362791078685}, {-31.219443530318813, 
  -29.83315006441914, -28.44685749373861, -27.060566713493138, 
  -25.67427951410491, -24.287999476379607, -22.901733761773965, 
  -21.515496692582875, -20.129316910922014, -18.743251691127593, 
  -17.357415542301762, -15.972037324450392, -14.587574125452027, 
  -13.204937597810458, -11.825940995673731, -10.45417095978494, 
  -9.096643966074282, -7.766786677328867, -6.489187996841209, 
  -5.3051376192151185, -4.273215708787706, -3.453313096869966, 
  -2.872913555397413, -2.5068183876018146, -2.2962977296636495, 
  -2.182508895731692, -2.1232140384754774, -2.092927946831543, 
  -2.077620052193964, -2.069924220197145, -2.066065747370522, 
  -2.064133860940819, -2.0631672538642625, -2.062683784190453, 
  -2.062442007798377, -2.0622002036947378, -2.0622002036947378, 
  -2.0622002036947378}, {-31.147441125324004, -29.761147647262298, 
  -28.37485505225776, -26.98856422336451, -25.60227692668161, 
  -24.215996694370602, -22.829730590608026, -21.443492743161023, 
  -20.057311405220098, -18.671243073792315, -17.2854007054046, 
  -15.900010063230946, -14.515522074651356, -13.13283620296525, 
  -11.753741844211536, -10.38177995030333, -9.02388331646123, 
  -7.693338996813699, -6.414547090056367, -5.228661220593295, 
  -4.194422880203504, -3.372307799739909, -2.7903741518814584, 
  -2.423479944964628, -2.212613751723623, -2.098685440017433, 
  -2.0393332716047734, -2.0090223022101883, -1.9937030094857628, 
  -1.9860017515649175, -1.9821406357300193, -1.98020744549763, 
  -1.97924019097196, -1.9787563986900245, -1.9785144612734156, 
  -1.9783934822435914, -1.978272496331759, -1.978272496331759}, {
  -31.081575781782483, -29.695282290995795, -28.308989670541358, 
  -26.922698790748544, -25.53641139226749, -24.150130956363995, 
  -22.763864445431803, -21.377625783706957, -19.991442817455873, 
  -18.605371230389586, -17.219522354649744, -15.834118713452447, 
  -14.449604789397023, -13.066867295842696, -11.687670680155387, 
  -10.315508144727277, -8.95722513972347, -7.625963425460771, 
  -6.345928216998935, -5.158138394934723, -4.121519199180893, 
  -3.2971697425517275, -2.713734038610957, -2.3460963356866698, 
  -2.1349328080995265, -2.0208966668997737, -1.9615053207808673, 
  -1.9311791798874627, -1.9158535105161782, -1.9081493805670517, 
  -1.9042869096056037, -1.9023530622625173, -1.9013854843237303, 
  -1.9009015316244449, -1.9006595143219212, -1.9005384954298865, 
  -1.900417469709697, -1.900417469709697}, {-31.021031435451054, 
  -29.63473793136948, -28.248445284325324, -26.862154351353336, 
  -25.47586684651494, -24.089586197900818, -22.70331926156358, 
  -21.31707974909346, -19.93089508161109, -18.54482009311895, 
  -17.158964418671797, -15.773547196617534, -14.389006176919803, 
  -13.006214755101318, -11.626911324929901, -10.254539249843303, 
  -8.895852914026616, -7.563842995285059, -6.282513603129261, 
  -5.092750193502382, -4.0536847236016325, -3.227078954317286, 
  -2.6421737202330533, -2.273848043399604, -2.0624348932263787, 
  -1.948322049290529, -1.8889092931801306, -1.8585774718143078, 
  -1.8432503306361752, -1.8355458218859364, -1.8316832527373688, 
  -1.8297493793504025, -1.8287817941831441, -1.8282978393218885, 
  -1.8280558213019338, -1.8279348021421329, -1.8278137762148343, 
  -1.8278137762148343}, {-30.965151022775242, -29.5788575048221, 
  -28.19256483003488, -26.806273841577024, -25.41998622576796, 
  -24.033705355216767, -22.647437975022445, -21.2611975749064, 
  -19.87501113240509, -18.48893259496639, -17.103069826988772, 
  -15.717638435303364, -14.333069145896019, -12.950221461543086, 
  -11.570806603328093, -10.198215977615796, -8.839109124088512, 
  -7.50631974076975, -6.22364445314652, -5.0318365900354305, 
  -3.990258372144363, -3.1613743239336993, -2.5750325970902077, 
  -2.2060744663740195, -1.9944589207060186, -1.8802999808527991, 
  -1.8208832179428573, -1.7905549927697457, -1.7752311685481625, 
  -1.7675287138438645, -1.7636672726567744, -1.76173398874518, 
  -1.760766704722032, -1.76028290203855, -1.7600409605094265, 
  -1.7599199796955924, -1.7597989921813186, -1.7597989921813186}, {
  -30.913397901026325, -29.527104368618375, -28.14081166492161, 
  -26.75452061864494, -25.36823288719937, -23.981951785379636, 
  -22.595683942666145, -21.209442617583385, -19.823254325435077, 
  -18.437172089847795, -17.051301930151947, -15.665855773324088, 
  -14.281257026634522, -12.898350718346776, -11.518819763826919, 
  -10.146001465627181, -8.786456681727296, -7.452856119192045, 
  -6.168782369906943, -4.974857896263603, -3.930699338203589, 
  -3.099515015218317, -2.5117703810731444, -2.142235332016694, 
  -1.9304641368127158, -1.8162891892555824, -1.7568854594576575, 
  -1.7265698937156417, -1.7112540597122208, -1.703556031839388, 
  -1.6996969141392058, -1.697764819760673, -1.696798137485703, 
  -1.6963146374260194, -1.6960728476467613, -1.6959519428174183, 
  -1.6958310313607003, -1.6958310313607003}, {-30.86532831440123, 
  -29.47903476694888, -28.0927420331634, -26.706450926709586, 
  -25.3201630749109, -23.933881732389626, -22.547613408291788, 
  -21.16137112051529, -19.775180903279303, -18.389094818715463, 
  -17.003216965858922, -15.617755441856833, -14.233126037227857, 
  -12.850158717266723, -11.470506944870557, -10.097451743489733, 
  -8.737451392385266, -7.4030074769166045, -6.117481819239683, 
  -4.921367223461425, -3.874559548612593, -3.04105292761549, 
  -2.451939557132067, -2.0818831570086522, -1.8700025796721287, 
  -1.755841195123132, -1.6964671763454309, -1.6661731208500614, 
  -1.650869835449236, -1.6431785474793814, -1.6393229183515445, 
  -1.637392598196221, -1.636426810552613, -1.635943759693004, 
  -1.6357021949854393, -1.6355814028099274, -1.6354606040857222, 
  -1.6354606040857222}, {-30.820571316327698, -29.434277753235254, 
  -28.047984988169652, -26.661693819155904, -25.275405842238577, 
  -23.889124249484908, -22.502855424941842, -21.116612136353126, 
  -19.73041991780562, -18.344329831870034, -16.95844398127226, 
  -15.572966481773593, -14.188305205909975, -12.805274461039392, 
  -11.425497097363884, -10.052195655471683, -8.691721877871682, 
  -7.35640197189983, -6.069370050898842, -4.870990399686129, 
  -3.8214635784789706, -2.985612612797326, -2.395165300664949, 
  -2.024643163300737, -1.8126989943302616, -1.6985802268953731, 
  -1.6392522363590631, -1.6089883305753323, -1.5937020379570597, 
  -1.5860197436229497, -1.5821687379109064, -1.5802407614030747, 
  -1.5792761536046462, -1.5787936946775687, -1.5785524264393298, 
  -1.578431782624317, -1.5783111323445302, -1.5783111323445302}, {
  -30.77881384966833, -29.392520270334217, -28.006227472785355, 
  -26.619936238805405, -25.233648131956944, -23.847366279346097, 
  -22.46109693510904, -21.0748526072138, -19.68865831037899, 
  -18.30256406917144, -16.91666991323734, -15.53117582387267, 
  -14.146481451314166, -12.7633848436928, -11.383477065114068, 
  -10.009919942442272, -8.648954701972261, -7.312727080795011, 
  -6.02417711462157, -4.824808865499692, -3.7710937234328905, 
  -2.9328763488309026, -2.341130552450613, -1.9701983516326205, 
  -1.7582359053784042, -1.6441882932650054, -1.5849222888642762, 
  -1.5546969620462145, -1.5394319929051237, -1.5317608870026362, 
  -1.5279156095200077, -1.5259905309270614, -1.5250273805734855, 
  -1.5245456524953744, -1.5243047502138405, -1.524184289510309, 
  -1.5240638224307843, -1.5240638224307843}, {-30.739789472844006, 
  -29.35349587666104, -27.96720304541455, -26.580911744039682, 
  -25.1946235024027, -23.8083413802201, -22.422071496860685, 
  -21.035826090805294, -19.64962963798844, -18.263531086169433, 
  -16.877628314419898, -15.492117015030136, -14.107388308651439, 
  -12.724223376769634, -11.344180310931593, -9.970357961281575, 
  -8.60888287227266, -7.271711191810972, -5.981499898344132, 
  -4.778359290584236, -3.7231787173275706, -2.8825728599089486, 
  -2.289564739118838, -1.9182782205658933, -1.7063423351248606, 
  -1.5923939011817718, -1.5332054828919062, -1.503026955288417, 
  -1.487787527597759, -1.4801297464131995, -1.4762912721694499, 
  -1.4743696307178193, -1.473408207853372, -1.4729273457542098, 
  -1.472686877021343, -1.4725666332320184, -1.4724463831599774, 
  -1.4724463831599774}, {-30.703269713042797, -29.316976099398453, 
  -27.930683233229296, -26.54439186200943, -25.15810348068383, 
  -23.77182107912947, -22.385550637048436, -20.999304113637404, 
  -19.61310542645961, -18.227002407319738, -16.841090706529425, 
  -15.455561571437462, -14.070797282976345, -12.687561542659244, 
  -11.30737827048469, -9.933281052546388, -8.571277643385029, 
  -7.233129225097678, -5.941242852628827, -4.73560312882194, 
  -3.677485076522672, -2.83446866278451, -2.2402351202925184, 
  -1.868650112165035, -1.6567851484475167, -1.5429634005575839, 
  -1.483867811895092, -1.4537440960209145, -1.4385343158396973, 
  -1.430891937601451, -1.4270613120404263, -1.4251436320381135, 
  -1.4241841992137685, -1.4237043344683418, -1.4234643649963676, 
  -1.4233443709835714, -1.423224370785475, -1.423224370785475}, {
  -30.669057345164603, -29.28276371344131, -27.89647081111434, 
  -26.510179367579205, -25.123890841624476, -23.737608150817515, 
  -22.351337130253903, -20.965089449968225, -19.57888844940312, 
  -18.19278080493613, -16.80685985927859, -15.421312257575524, 
  -14.036511128189023, -12.653202073640378, -11.272873631011262, 
  -9.898491805668016, -8.535941346858587, -7.196781644966215, 
  -5.903161895126525, -4.694941683102914, -3.633810369362617, 
  -2.788361338531822, -2.19294006101815, -1.8211124829415217, 
  -1.6093623229428895, -1.495694254287774, -1.4367063838264413, 
  -1.4066452857970808, -1.3914691481187844, -1.383844193472214, 
  -1.3800224327229196, -1.3781092236883092, -1.3771520360270118, 
  -1.376673296287766, -1.3764338899256547, -1.376314177619559, 
  -1.376194459229372, -1.376194459229372}, {-30.636981104377558, 
  -29.25068745395299, -27.864394514223566, -26.478102995883884, 
  -25.091814320321518, -23.705531330305114, -22.319259711345943, 
  -20.933010834362424, -19.54680744077471, -18.160695011754406, 
  -16.774764502954756, -15.38919779880102, -14.004358559650928, 
  -12.620973664559068, -11.240495044310642, -9.865818778933052, 
  -8.502702329021401, -7.162496306164188, -5.8670838077645096, 
  -4.656199915063421, -3.591977918684368, -2.744074237478711, 
  -2.147503737323343, -1.7754896078991256, -1.5638976522101233, 
  -1.4504097414265784, -1.3915441243730367, -1.3615532453024837, 
  -1.346414634943763, -1.3388090674482773, -1.3349971585872826, 
  -1.3330889153839043, -1.3321342206488511, -1.3316567298802575, 
  -1.331417948630965, -1.3312985490382279, -1.3311791434660616, 
  -1.3311791434660616}, {-30.60689148096695, -29.220597811214354, 
  -27.834304832828966, -26.448013237177737, -25.061724406993775, 
  -23.675441107740173, -22.28916887033058, -20.902918756542125, 
  -19.516712889728097, -18.130595515789043, -16.74465512328437, 
  -15.3590686762261, -13.974190049094224, -12.590726767793539, 
  -11.210092921768393, -9.835112293303519, -8.471410701413124, 
  -7.130122822282285, -5.832857092441768, -4.619224411985797, 
  -3.551832585990565, -2.701452265957639, -2.1037719235413594, 
  -1.7316273663200457, -1.5202365309100727, -1.406954742156597, 
  -1.3482255619888242, -1.3183122994488172, -1.3032149919766334, 
  -1.2956307186238603, -1.2918296199487382, -1.2899268229256584, 
  -1.2889748615914254, -1.2884987401057784, -1.2882606441442024, 
  -1.2881415873569608, -1.2880225246980774, -1.2880225246980774}, {
  -30.57865734272854, -29.19236365301707, -27.80607063471402, 
  -26.419778959227845, -25.033489969375534, -23.647206350791382, 
  -22.260933474745283, -20.87468208378217, -19.48847366301221, 
  -18.102351182734463, -16.716400583842066, -15.330793749143034, 
  -13.94587444707691, -12.56233021576754, -11.181536056975265, 
  -9.806241055203483, -8.44193496373563, -7.099529188413886, 
  -5.800348591439987, -4.583880001545218, -3.5132373824909773, 
  -2.6603585000898664, -2.0616086066095747, -1.6893898544987707, 
  -1.4782425668069465, -1.3651923497592986, -1.306613439931204, 
  -1.2767849894707801, -1.2617326521663896, -1.2541715239184346, 
  -1.2503821652316358, -1.248485280369173, -1.247536285695527, 
  -1.2470616501900902, -1.2468242978817057, -1.2467056130869076, 
  -1.246586922531061, -1.246586922531061}, {-30.552163197539787, 
  -29.16586948723483, -27.779576427744917, -26.393284669885407, 
  -25.006995515287997, -23.620711567219935, -22.23443803223117, 
  -20.848185323483357, -19.461974267546456, -18.07584651854428, 
  -16.689885388637954, -15.304257517627429, -13.919296245617192, 
  -12.535668483644393, -11.154708888529827, -9.779089419495417, 
  -8.414159267002855, -7.0705990440071895, -5.769440747895065, 
  -4.550047006213273, -3.476070719592821, -2.620671439195589, 
  -2.02089323992628, -1.6486566380084162, -1.4377948323778287, 
  -1.3250011221714626, -1.2665859678864928, -1.236849324610504, 
  -1.2218455174687797, -1.2143093298155412, -1.2105326127181435, 
  -1.2086420917786007, -1.2076962898868413, -1.2072232534822651, 
  -1.2069867014023923, -1.2068684168914456, -1.2068092725180175, 
  -1.2067501267325431}, {-30.527306956501018, -29.141013224964595, 
  -27.754720123011847, -26.368428280227068, -24.982138955780727, 
  -23.595854668021225, -22.209580453675247, -20.823326386315696, 
  -19.437112613566022, -18.05097943258076, -16.665007445275286, 
  -15.279357885712093, -13.894353341399176, -12.510639452593761, 
  -11.129509263416905, -9.753555153038793, -8.387981177283162, 
  -7.043229436303433, -5.740029366712105, -4.51761899768607, 
  -3.4402241591742513, -2.582282759176657, -1.9815184971037794, 
  -1.6093205038382081, -1.3987856163293912, -1.2862728334664493, 
  -1.2280345735228995, -1.1983965337281475, -1.1834447104907058, 
  -1.1759352040252538, -1.1721720022200186, -1.1702882829031391, 
  -1.16934589285482, -1.1688745651347499, -1.168638868088422, 
  -1.1685210112671456, -1.1684620807817863, -1.1684031489132065}, {
  -30.50399809237847, -29.117704338969588, -27.73141119327203, 
  -26.345119262998043, -24.958829763574915, -23.572545125868366, 
  -22.186270211654435, -20.800014744663493, -19.413798173069086, 
  -18.027659396066202, -16.641676223410197, -15.256004319863374, 
  -13.87095519428174, -12.48715256836307, -11.105846595693837, 
  -9.729547593563213, -8.363309834767408, -7.017328979094722, 
  -5.712021770645765, -4.48650094586319, -3.405600558310023, 
  -2.545095460553958, -1.943388420290299, -1.5712856070756838, 
  -1.3611185696960149, -1.2489106199340312, -1.1908620486445198, 
  -1.1613292115121179, -1.1464327207327394, -1.1389515817437874, 
  -1.1352027413469816, -1.1333262474498393, -1.1323874813277175, 
  -1.1319179683795215, -1.1316831794219127, -1.131565776820764, 
  -1.1315070734894206, -1.1314483688041608}, {-30.482156113100867, 
  -29.095862337175937, -27.709569146446388, -26.323277126108827, 
  -24.93698744656021, -23.550702448609318, -22.164426813933236, 
  -20.778169906124095, -19.39195045331769, -18.005805915588112, 
  -16.61981122826538, -15.234116322511726, -13.849021300862294, 
  -12.465127314905294, -11.083640340236364, -9.706986123608297, 
  -8.340064427915934, -6.992816326555002, -5.685335271286679, 
  -4.456607682534068, -3.372112528132475, -2.509022330855798, 
  -1.9064168827471166, -1.5344659318214926, -1.3247071662078531, 
  -1.2128274404468655, -1.1549810096341713, -1.1255597789766987, 
  -1.1107218651175614, -1.1032707261980677, -1.0995370660595147, 
  -1.097668207640557, -1.09673327063163, -1.0962656750881739, 
  -1.0960318455455484, -1.095914922830117, -1.0958564594861977, 
  -1.0957979948180756}, {-30.461709288514648, -29.07541548942789, 
  -27.689122252374784, -26.30283013939053, -24.91654027455021, 
  -23.53025490602263, -22.14397853022002, -20.757720140265263, 
  -19.37149772359731, -17.98534725986311, -16.59934072740271, 
  -15.213622158841542, -13.828479921300524, -12.444491941268216, 
  -11.062818719749352, -9.685798897735864, -8.318172920890985, 
  -6.9696189003511195, -5.659895893146776, -4.427862617156589, 
  -3.339681144957973, -2.4739846595007697, -1.870526303814082, 
  -1.4987840044717962, -1.2894734150644944, -1.1779447892487525, 
  -1.1203126103199808, -1.0910091963819604, -1.0762330009392076, 
  -1.0688134416101693, -1.065095753641012, -1.0632349271879842, 
  -1.0623040176684724, -1.0618384387508657, -1.0616056182420168, 
  -1.061489200223758, -1.0614309892735045, -1.0613727770291053}, {
  -30.442593582367795, -29.05629975947167, -27.670006474799933, 
  -26.283714266578848, -24.897424211266554, -23.5111384618018, 
  -22.124861324151965, -20.73860141061122, -19.352375947205118, 
  -17.966219391729645, -16.580200682724758, -15.19445778881025, 
  -13.809267011372071, -12.425182393715156, -11.043317657012441, 
  -9.665921774984922, -8.29757098624624, -6.947671822006043, 
  -5.6356373028000135, -4.400196657356145, -3.308234865566894, 
  -2.439911157077213, -1.8356465681543321, -1.4641698112613244, 
  -1.2553467780079182, -1.1441916130578555, -1.0867854591586534, 
  -1.0576058804688377, -1.0428944431260212, -1.0355079904745532, 
  -1.0318070399822152, -1.0299546285836996, -1.0290279382058392, 
  -1.0285644717670885, -1.02833270822523, -1.0282168188724266, 
  -1.028158872300399, -1.0281009244645618}, {-30.424751751868776, 
  -29.03845790451444, -27.652164570926388, -26.2658722648731, 
  -24.879582013898105, -23.49329587311478, -22.10701795285509, 
  -20.72075647420383, -19.33452788101341, -17.948365067715933, 
  -16.56233385005176, -15.176565966743137, -13.791325322098645, 
  -12.40714141542364, -11.025079874707233, -9.647297418916493, 
  -8.278201105221587, -6.926917012862938, -5.612499905410021, 
  -4.373547296030806, -3.277708608893937, -2.4067370412895848, 
  -1.8017141115373507, -1.4305598823288697, -1.222263252957132, 
  -1.111503394746737, -1.0543347029970223, -1.025284788270951, 
  -1.0106410480789167, -1.0032891774097046, -0.9996057034395616, 
  -0.9977620769598696, -0.9968397907403813, -0.9963785293098835, 
  -0.9961478690049596, -0.9960325314538929, -0.9959748608285598, 
  -0.9959171889699707}, {-30.408132585066458, -29.021838712604232, 
  -27.635545328800507, -26.2492529223163, -24.862962470481175, 
  -23.47667592798444, -22.090397204325335, -20.704134118984808, 
  -19.317902312854134, -17.93173307542906, -16.545689016519855, 
  -15.159895478749803, -13.77460363720044, -12.390317784007966, 
  -11.008054133072024, -9.629874535494734, -8.260011805890935, 
  -6.907302431898387, -5.590430078873949, -4.347857835288638, 
  -3.248042974276303, -2.37440325973327, -1.7686711433098692, 
  -1.397896512457758, -1.1901645943576131, -1.079821373751771, 
  -1.0229012475642094, -0.9939866376554433, -0.9794134342372327, 
  -0.9720975697364891, -0.9684322854197662, -0.966597800676933, 
  -0.9656800970870433, -0.96522112991585, -0.9649916174772319, 
  -0.9648768540435474, -0.9648194705229715, -0.9647620857998525}, {
  -30.392690252366446, -29.0063963541463, -27.62010291882684, 
  -26.23381040931159, -24.8475197514161, -23.461232796805483, 
  -22.07495324894601, -20.688688515314357, -19.302453413039846, 
  -17.91627758508062, -16.530220352116032, -15.144400494277614, 
  -13.759056124686273, -12.37466566318103, -10.992194581699623, 
  -9.613607225120322, -8.242957015480357, -6.888781427702744, 
  -5.569379521879433, -4.323076723480683, -3.2191835724671, -2.342855825718942
  , -1.7364649817634465, -1.3661270947035735, -1.1589976464583494, 
  -1.0490918794241426, -0.9924310909063548, -0.9636572408047812, 
  -0.9491573155841428, -0.9418788309952087, -0.9382324239026294, 
  -0.9364074248492708, -0.9354944759061515, -0.9350378890129458, 
  -0.9348095674524847, -0.9346953996427333, -0.9346383139803456, 
  -0.9345812271462324}, {-30.378383753203387, -28.992089828575445, 
  -27.6057963404405, -26.219503725294707, -24.83321285613984, 
  -23.446925479017295, -22.060645086161287, -20.674378662645832, 
  -19.28814018104076, -17.901957596168486, -16.515886856369356, 
  -15.130040012821775, -13.74464178360098, -12.360144049575041, 
  -10.977460206497955, -9.598454429836359, -8.226995507878293, 
  -6.871312185649999, -5.549304696873887, -4.299156986212712, 
  -3.1910804173979783, -2.3120452480604867, -1.7050474833004403, 
  -1.3352035478146755, -1.1287137704224977, -1.0192657582278672, 
  -0.9628747506691053, -0.9342469315446568, -0.9198229289967882, 
  -0.9125831483065334, -0.9089562808072715, -0.9071410987140565, 
  -0.9062330700735715, -0.905778946291293, -0.9055518570266946, 
  -0.9054383055500368, -0.9053815281004938, -0.9053247495100942}, {
  -30.365176442565236, -28.978882490880302, -27.59258894863148, 
  -26.20629622525836, -24.82000513965053, -23.433717329628838, 
  -22.04743607100167, -20.66116791605241, -19.274925972013797, 
  -17.888736464010687, -16.50265188489444, -15.11677739048794, 
  -13.731323970626095, -12.346716299417084, -10.963814356509554, 
  -9.58437946040335, -8.212090431035923, -6.854857254956146, 
  -5.530166352618716, -4.27605573592212, -3.1636875936737927, 
  -2.281926039404872, -1.6743745499636848, -1.3050818220150386, 
  -1.099268349841591, -0.9902978793541246, -0.9341867697969282, 
  -0.9057100710870425, -0.8913645400101854, -0.8841647381453975, 
  -0.88055804777088, -0.8787530014123945, -0.8778500524630285, 
  -0.8773984714860886, -0.877172654364585, -0.8770597391446407, 
  -0.8770032798697538, -0.8769468194848792}, {-30.353035624961297, 
  -28.966741645571396, -27.580448047912753, -26.1941552137204, 
  -24.807863906475784, -23.421575653187237, -22.03529350805319, 
  -20.649023580197525, -19.262778090775498, -17.876581493723158, 
  -16.49048274337896, -15.104579933999185, -13.719069994125526, 
  -12.334349722651359, -10.951224338181888, -9.571349590835775, 
  -8.198208901851928, -6.8393831432211085, -5.511929113895436, 
  -4.253733747478655, -3.136962495993528, -2.252456290563403, 
  -1.644405702776735, -1.2757214706008613, -1.070620362105061, 
  -0.9621467062030564, -0.906325288100151, -0.8780046196392601, 
  -0.8637400144458088, -0.8565814179787593, -0.8529955177908923, 
  -0.8512009136336686, -0.8503031975915271, -0.8498542360235564, 
  -0.8496297293458404, -0.8495174695326738, -0.8494613380074039, 
  -0.8494052054029678}, {-30.34193220572433, -28.955638197983276, 
  -27.569344543622428, -26.183051596026083, -24.79676006197513, 
  -23.41047135508052, -22.024188302760777, -20.63791656063945, 
  -19.251667443109042, -17.86546359153176, -16.479350338905533, 
  -15.093418552037638, -13.707850765526599, -12.323015234398396, 
  -10.939661066978946, -9.559335710291261, -8.185321658434425, 
  -6.824859968348099, -5.49456112822465, -4.232155089551467, 
  -3.110865782457562, -2.22359730058659, -1.6151037106238955, 
  -1.2470852770851009, -1.0427320053594928, -0.9347739234667868, 
  -0.8792516694232652, -0.8510917636125799, -0.83691044563837, 
  -0.8297942335007831, -0.8262297124641801, -0.8244458448566709, 
  -0.8235535088614414, -0.8231072402635132, -0.8228840808079122, 
  -0.8227724947901325, -0.8227167002086452, -0.8226609045787208}, {
  -30.331840391375202, -28.945546354639173, -27.559252642288477, 
  -26.172959578712838, -24.78666781270492, -23.400378641902854, 
  -22.01409466179411, -20.62782106419843, -19.241568236133904, 
  -17.855356965146903, -16.469228880336395, -15.083267455649201, 
  -13.697640499764733, -12.312687055475834, -10.929098767939053, 
  -9.548312020096898, -8.173402636017721, -6.811257200015838, 
  -5.477911085233132, -4.211286803305004, -3.0853608805325696, 
  -2.1953132541444713, -1.5864342662191828, -1.2191389294443682, 
  -1.0155683726121796, -0.9081441113675632, -0.8529301759681576, 
  -0.8249355899839912, -0.8108398288144582, -0.8037671330191184, 
  -0.8002245563769186, -0.7984517077412124, -0.7975648929529763, 
  -0.7971213878922542, -0.7968996109391132, -0.7967887163560816, 
  -0.7967332675378545, -0.7966778177017837}, {-30.322737432259267, 
  -28.93644336588741, -27.550149594265154, -26.163856412146796, 
  -24.777564409055017, -23.39127476409155, -22.004989835685265, 
  -20.618714341595563, -19.232457720947277, -17.846238866410072, 
  -16.46009562097006, -15.074103900920568, -13.68841645800179, 
  -12.303342455217042, -10.919514719253591, -9.538255796734997, 
  -8.162429337920312, -6.798563200814699, -5.462321334273004, 
  -4.1910986214467325, -3.0604137311459807, -2.167570939234245, 
  -1.5583657021735215, -1.1918507344830507, -0.9890971659939123, 
  -0.8822244600652878, -0.8273276827863153, -0.7995028008251684, 
  -0.7854947756370904, -0.7784666820063428, -0.7749465916592291, 
  -0.7731850326842948, -0.7723038743810909, -0.7718632004798442, 
  -0.7716428398360937, -0.7715326535902218, -0.7714775589861976, 
  -0.7714224633947468}, {-30.314603401865664, -28.92830930522072, 
  -27.542015473052377, -26.155722169842235, -24.769429924568417, 
  -23.383139795246986, -21.996853898149272, -20.610576466774678, 
  -19.224315971948496, -17.838089370623365, -16.45193063788116, 
  -15.065907968339648, -13.680158727026743, -12.294961530917512, 
  -10.91088903068188, -9.529147132363265, -8.152381361435136, 
  -6.786745410769411, -5.447400897370849, -4.171562721828026, 
  -3.0359925341066587, -2.1403394994151395, -1.5308687413480648, 
  -1.1651913665084541, -0.9632884453747328, -0.8569845184274562, 
  -0.8024134266328186, -0.7747624621914213, -0.7608442631089747, 
  -0.7538618120093975, -0.7503647268974267, -0.7486147167336926, 
  -0.7477393444097296, -0.7473015663946719, -0.7470826544185536, 
  -0.7469731926876816, -0.7469184603864591, -0.7468637271280143}, {
  -30.307421008223944, -28.92112688067288, -27.534832986692393, 
  -26.148539559858325, -24.76224706733813, -23.375956443529848, 
  -21.989669557482006, -20.603390148301486, -19.21712569824081, 
  -17.83089118795647, -16.444716643337827, -15.058662374233888, 
  -13.672850030737223, -12.287527019438807, -10.903204456523511, 
  -9.52096878632626, -8.143241464921715, -6.775789755136004, -5.43325203501017
  , -4.152653510756182, -3.012067522084822, -2.113590215726729, 
  -1.5039162766381737, -1.139133645467594, -0.9381144064831188, 
  -0.8323959723112964, -0.7781587843316797, -0.7506857825201825, 
  -0.7368594119840665, -0.7299235990666063, -0.726450015553479, 
  -0.7247118020085587, -0.723842339472977, -0.7234075192248743, 
  -0.7231900868508017, -0.7230813651006422, -0.7230270028347043, 
  -0.7229726396414984}, {-30.30117543358327, -28.914881274497954, 
  -27.528587317449052, -26.1422937644785, -24.756001019686746, 
  -23.369709891340978, -21.983421996240697, -20.597140569045425, 
  -19.210872083315827, -17.82462950313638, -16.438438824501926, 
  -15.052352310491631, -13.666475569902996, -12.28102413703995, 
  -10.896446235026767, -9.513706005802616, -8.134994781436859, 
  -6.765680687195216, -5.419856698746124, -4.134347431955607, 
  -2.9886107604260257, -2.0872963142265357, -1.4774831761131966, 
  -1.1136523404771426, -0.913549184459838, -0.8084324482886079, 
  -0.7545370765828459, -0.7272459164693258, -0.7135132906177298, 
  -0.706625067562617, -0.7031754598220252, -0.7014492795573994, 
  -0.7005858450334959, -0.7001540416369975, -0.6999381184005286, 
  -0.6998301513971665, -0.6997761665491319, -0.6997221808035009}, {
  -30.29585419925446, -28.909560008012335, -27.523265986649896, 
  -26.136972305052616, -24.750679303008734, -23.36438766016404, 
  -21.978098736087244, -20.591815251024297, -19.205542649900806, 
  -17.819291840299943, -16.43308470829227, -15.046965309446783, 
  -13.66102288709409, -12.275440444397637, -10.890601953709517, 
  -9.507346395306074, -8.127628810311018, -6.7564050136213885, 
  -5.407199064764907, -4.116622797755985, -2.9655959686500246, 
  -2.061432795722382, -1.4515461100774976, -1.0887239953184777, 
  -0.8895686794179946, -0.7850693393841381, -0.731523393781494, 
  -0.7044177907659377, -0.6907807408261458, -0.6839410160919215, 
  -0.6805158364956265, -0.6788019152241049, -0.677944621448924, 
  -0.6775158912425744, -0.6773015053054704, -0.6771943071279058, 
  -0.6771407067368044, -0.6770871054774649}, {-30.291447053062257, 
  -28.90515282904705, -27.518858742138534, -26.1325649294494, 
  -24.746271665223066, -23.359979498018465, -21.973689525241838, 
  -20.5874039428592, -19.201127147416265, -17.81486795045688, 
  -16.42864404885836, -15.042491131374192, -13.65648175422014, 
  -12.270765734235685, -10.885661437174829, -9.501879804876404, 
  -8.121133305947241, -6.747951782982963, -5.395265413353103, 
  -4.099459639611863, -2.9429983606998595, -2.0359762848013596, 
  -1.4260833971458404, -1.0643267729975863, -0.8661504011085301, 
  -0.7622836499260177, -0.7090944409479482, -0.6821779491638639, 
  -0.6686382228533243, -0.6618478624293236, -0.6584475419366264, 
  -0.6567460946204178, -0.6558950489446227, -0.6554694455710072, 
  -0.6552566237463577, -0.6551502077990833, -0.6550969985666472, 
  -0.6550437884949888}, {-30.287945877337904, -28.901651619940353, 
  -27.51535746626722, -26.129063520049144, -24.742769988766078, 
  -23.356477287452638, -21.97018624647682, -20.583898527769758, 
  -19.197617459973905, -17.811349719493045, -16.42510873559453, 
  -15.038921672525712, -13.652844080611024, -12.266991939497496, 
  -10.881616655474986, -9.497298238835722, -8.115500187230335, 
  -6.740312194868238, -5.384044028147394, -4.08283957549379, 
  -2.9207945025931297, -2.010904895692936, -1.401074866863138, 
  -1.0404403169065992, -0.8432733302272936, -0.740053857043654, 
  -0.6872283993034433, -0.6605044140452421, -0.6470636769809353, 
  -0.6403235051426104, -0.6369484536908783, -0.6352596847401011, 
  -0.6344149892280441, -0.6339925636840297, -0.633781331461423, 
  -0.6336757104870191, -0.6336228987839857, -0.6335700862703767}, {
  -30.28534461579759, -28.899050324416187, -27.51275610277541, 
  -26.126462020622313, -24.740168217470256, -23.35387497242304, 
  -21.967582843996492, -20.581292950455282, -19.195007533260462, 
  -17.808731095059787, -16.422472720040215, -15.036250892052601, 
  -13.650103839984405, -12.264113060407178, -10.87846165136973, 
  -9.493595783456842, -8.110723465896339, -6.733479527989586, 
  -5.373525113499576, -4.066745692052807, -2.898962182442447, 
  -1.9861981128655954, -1.3765017367619827, -1.0170456264870988, 
  -0.820917794263052, -0.7183597867117366, -0.6659048023902081, 
  -0.6393765625645043, -0.6260363996794799, -0.6193471997459381, 
  -0.6159978066418857, -0.6143219101133572, -0.6134836616432654, 
  -0.6130644623302889, -0.6128548439010079, -0.6127500299927556, 
  -0.6126976218651744, -0.6126452129552707}, {-30.283639218016617, 
  -28.89734489205837, -27.511050601263968, -26.124756380803852, 
  -24.738462301038698, -23.352168502769036, -21.965875267912594, 
  -20.57958316157159, -19.1932933190173, -17.807008031058967, 
  -16.420731960376038, -15.034474756523949, -13.648257015009925, 
  -12.262125109129043, -10.876192485188525, -9.49076855225442, 
  -8.106799192576764, -6.727449085984096, -5.363700728494783, 
  -4.051162439761297, -2.8774802958871915, -1.961836684557995, 
  -1.3523465020547727, -0.9941249455988054, -0.7990653560891778, 
  -0.6971825025423661, -0.6451044249377176, -0.618775015536678, 
  -0.6055369325026563, -0.5988994475958201, -0.5955760819072303, 
  -0.5939132417033818, -0.5930815320675813, -0.5926656048419545, 
  -0.5924576231241767, -0.5923536277386675, -0.5923016289142106, 
  -0.592249629335267}, {-30.28282760053346, -28.896533239414694, 
  -27.510238878299305, -26.123944517197412, -24.73765015614952, 
  -23.35135579531763, -21.96506143534974, -20.57876707883785, 
  -19.19247273614996, -17.806178448758057, -16.41988438255, 
  -15.033591201075401, -13.647301558504218, -12.261026071059675, 
  -10.874807196331272, -9.488814647934168, -8.103725419556913, 
  -6.7222181599538855, -5.354564736582668, -4.036075539484989, 
  -2.856328739767761, -1.937802527698384, -1.3285928364117816, 
  -0.9716616620516709, -0.7776987137559929, -0.6765042057815742, 
  -0.6248091829312179, -0.5986815375261132, -0.5855469621810547, 
  -0.5789618959858832, -0.5756649069334695, -0.5740152970012394, 
  -0.573190213006342, -0.5727776012295314, -0.5725712778935141, 
  -0.5724681118632563, -0.5724165277575216, -0.5723649429247001}, {
  -30.282909623913756, -28.896615227060913, -27.510320794477412, 
  -26.124026290439467, -24.73773164352015, -23.351436710948107, 
  -21.965141207510744, -20.578844564103246, -19.192545647797612, 
  -17.806242213865133, -16.419929857363663, -15.033600106518087, 
  -13.647237370586678, -12.260815882082492, -10.874305780737442, 
  -9.487734140331145, -8.101502179583584, -6.717786007085887, 
  -5.346112770015421, -4.021471899151644, -2.8354883177019454, 
  -1.9140786428778103, -1.3052255024907273, -0.9496402169734852, 
  -0.7568016101547727, -0.6563081451805205, -0.6050020435526727, 
  -0.5790789468057737, -0.5660492305853663, -0.5595172481105599, 
  -0.5562469654596968, -0.5546107499892524, -0.5537923735562359, 
  -0.5533831181450813, -0.5531784736383175, -0.5530761471843235, 
  -0.5530249829071334, -0.5529738179298005}, {-30.283887085379966, 
  -28.897592652230443, -27.511298147053616, -26.125003497829148, 
  -24.73870856053731, -23.352413047222356, -21.96611638230765, 
  -20.57981741597942, -19.193513853968273, -17.807201129169652, 
  -16.420870193124173, -15.034503292013532, -13.648066291401728, 
  -12.261496421390516, -10.87469018392956, -9.48752905994401, 
  -8.100131480333703, -6.714153844967711, -5.338342208543286, 
  -4.00733953935872, -2.8149406533862495, -1.890649038221546, 
  -1.2822302710644222, -0.928046022865976, -0.7363587514051232, 
  -0.6365785355923951, -0.5856669438450037, -0.5599510340379745, 
  -0.5470274534099944, -0.5405491817486618, -0.5373059162007022, 
  -0.5356832498238584, -0.534871658087967, -0.5344657975648058, 
  -0.5342628511371279, -0.5341613738814777, -0.534110634243164, 
  -0.5340598939311775}, {-30.28576372687689, -28.89946925687989, 
  -27.513174678008127, -26.12687988139389, -24.74058464932288, 
  -23.35428854645107, -21.967990702428608, -20.581689377908724, 
  -19.19538109960982, -17.809058942619075, -16.422709143732206, 
  -15.036304523184645, -13.649792109277652, -12.263071519747443, 
  -10.875964309501228, -9.48820340693647, -8.099617314420147, 
  -6.711324861481551, -5.3312521720666854, -3.9936675269107056, 
  -2.7946681117941368, -1.8674986611539544, -1.2595938477466453, 
  -0.9068653893556785, -0.7163557329706396, -0.6173004842992206, 
  -0.5667887171037073, -0.5412824886806632, -0.5284662465812072, 
  -0.5220422756709606, -0.5188263192538759, -0.5172173472420782, 
  -0.5164126126524794, -0.5160101831951412, -0.5158089529237608, 
  -0.5157083339021332, -0.5156580234198025, -0.5156077122897815}, {
  -30.288545258703753, -28.90225075132116, -27.51595609767822, 
  -26.129661151521685, -24.74336562036628, -23.35706891932649, 
  -21.970769878971325, -20.584466161799057, -19.19815309824764, 
  -17.81182137096212, -16.425452432336535, -15.039009535793507, 
  -13.652420584452699, -12.265546983317646, -10.878134043180461, 
  -9.489763175737822, -8.099965685072004, -6.70930424041988, 
  -5.324843527173167, -3.9804459154010576, -2.774653727278712, 
  -1.8446133371800113, -1.237303806447027, -0.8860854557762167, 
  -0.6967789726380217, -0.5984599242030724, -0.5483530261302304, 
  -0.5230588322536367, -0.5103510595242297, -0.5039819429062148, 
  -0.5007935693643087, -0.4991984278260477, -0.4984006182451807, 
  -0.49800165373682315, -0.49780215655128945, -0.4977024042254495, 
  -0.497652527129232, -0.4976026494108052}, {-30.292239399107903, 
  -28.905944853815175, -27.519650124351976, -26.133355026554923, 
  -24.74705919211851, -23.360761884516794, -21.974461631038135, 
  -20.58815548762034, -19.20183757158389, -17.815496139353648, 
  -16.429107790950315, -15.042626075380937, -13.655959488763399, 
  -12.268930633460089, -10.881207292863444, -9.492216395638719, 
  -8.101184647891309, -6.708099203232295, -5.319118907718873, 
  -3.9676656920577718, -2.7548811378698845, -1.8219797149154224, 
  -1.2153485287973418, -0.8656941298298824, -0.6776156496059572, 
  -0.5800435531273469, -0.5303463025926314, -0.5052663577102297, 
  -0.4926681145348599, -0.4863543701112252, -0.48319383529367477, 
  -0.48161265137121534, -0.480821830173774, -0.4804263622525256, 
  -0.48022861395958544, -0.4801297362298254, -0.480080296469097, 
  -0.4800308561111259}, {-30.296855930511093, -28.910561346798197, 
  -27.524266540494644, -26.137971289016843, -24.751675147218766, 
  -23.36537722489304, -21.97907574196365, -20.592767139633555, 
  -19.206444305729317, -17.820093037592112, -16.43368501669994, 
  -15.04716395353877, -13.660418661965993, -12.273232363156978, 
  -10.885194045289655, -9.495573188054331, -8.103284369364644, 
  -6.707719067590185, -5.314082749850198, -3.9553187301580177, 
  -2.7353345251760555, -1.7995852166895905, -1.193717148887188, 
  -0.8456800316716016, -0.6588536490251874, -0.5620387785688559, 
  -0.5127556918341963, -0.48789207425517334, -0.47540435159631067, 
  -0.46914646238565505, -0.4660140046336438, -0.46444689669895267, 
  -0.4636631228704363, -0.46327118097882286, -0.4630751962871697, 
  -0.4629772005046934, -0.4629282017542687, -0.4628792024310447}, {
  -30.302406773334923, -28.916112150707253, -27.52981726657413, 
  -26.143521859437097, -24.757225406320178, -23.370926861355276, 
  -21.98462413314156, -20.598313040218923, -19.21198522503426, 
  -17.825623993956167, -16.43919604567307, -15.052635121781362, 
  -13.66581008565747, -12.278464211043651, -10.890106440324946, 
  -9.499845841422639, -8.10627720310414, -6.708175323753157, 
  -5.3097413421091035, -3.94339774638857, -2.715998559363217, 
  -1.777417994125037, -1.172399502729261, -0.8260324428401108, 
  -0.6404815114128193, -0.5444336673231694, -0.49556900255234637, 
  -0.47092365703096467, -0.45854737806366375, -0.45234579295400473, 
  -0.44924163348622764, -0.4476887113359835, -0.4469120395707699, 
  -0.44652365100489066, -0.4463294435497891, -0.44623233652903005, 
  -0.4461837821953275, -0.44613522731273464}, {-30.308906078716607, 
  -28.922611416695958, -27.53631645377685, -26.150020889067687, 
  -24.763724120805925, -23.37742494554898, -21.99112095674176, 
  -20.60480734259445, -19.21847448480995, -17.83210316793162, 
  -16.445655045656988, -15.059053764307505, -13.672147976087315, 
  -12.284640454330722, -10.895958864143736, -9.50504890503021, 
  -8.110177785117552, -6.709481730047522, -5.306102891532532, 
  -3.9318962625866787, -2.6968583488127416, -1.755466888164159, 
  -1.1513860819452257, -0.806741259531498, -0.6224883864341931, 
  -0.5272168994759191, -0.47877466084046466, -0.45434940116540584, 
  -0.44208542270860635, -0.43594055720743985, -0.43286490050376053, 
  -0.43132626555334436, -0.4305567463522238, -0.4301719363106533, 
  -0.429979518678424, -0.42988330670929936, -0.429835199936466, 
  -0.4297870926381114}, {-30.31637034177026, -28.930075639895815, 
  -27.54378059726906, -26.157484873144405, -24.77118778605084, 
  -23.384887973127032, -21.998582708973018, -20.612266544079944, 
  -19.225928584595323, -17.83954706348383, -16.453078529422424, 
  -15.066436411307802, -13.679448897515075, -12.291777722273569, 
  -10.902768062965462, -9.511199303421867, -8.115003149771704, 
  -6.711654429133121, -5.303177606950661, -3.9208085713419356, 
  -2.6778993940661455, -1.7337213930723934, -1.1306679912245274, 
  -0.78779694977101, -0.6048639906063173, -0.5103777263134548, 
  -0.46236166814595475, -0.4381581797336501, -0.42600729367782225, 
  -0.41991953065885174, -0.41687256484190965, -0.4153483103182692, 
  -0.4145859900853941, -0.4142047817177867, -0.41401416547013953, 
  -0.4139188543302241, -0.4138711980062269, -0.41382354117953046}, {
  -30.324818537464708, -28.938523795294035, -27.552228672074754, 
  -26.165932786764788, -24.77963537729954, -23.393334919628153, 
  -22.007028365962118, -20.62070962197755, -19.234366504040334, 
  -17.847974664946616, -16.461485490623822, -15.074802074888558, 
  -13.687731898185127, -12.299895132277284, -10.910553279971912, 
  -9.518316491345214, -8.120773445816047, -6.714730759924473, 
  -5.3009778010197754, -3.9101297049747648, -2.659107545788556, 
  -1.7121716239965845, -1.1102369091615667, -0.7691905140915659, 
  -0.5875985685292965, -0.49390593175875636, -0.44631956275037615, 
  -0.4223394052406189, -0.4103023399709268, -0.4042720304170594, 
  -0.40125392763162915, -0.3997441387649251, -0.39898905990412287, 
  -0.3986114743594918, -0.39842267005769805, -0.3983282650243166, 
  -0.3982810617869903, -0.39823385806923484}, {-30.33427228167121, 
  -28.94797749878129, -27.561682294123433, -26.175386245935982, 
  -24.78908851071447, -23.402787401525327, -22.016479544802923, 
  -20.630158194622194, -19.243809863959132, -17.857407598080986, 
  -16.47089756486944, -15.084172410165337, -13.697018671468257, 
  -12.309014451069155, -10.919336414068557, -9.526422526632834, 
  -8.127509214027443, -6.718676058343778, -5.299518012904467, 
  -3.8998554074320393, -2.6404689664937795, -1.6908082877004096, 
  -1.0900850521229575, -0.7509134493730323, -0.5706828572978201, 
  -0.47779179698407853, -0.43063838442307584, -0.40688299427523894, 
  -0.3949604160894149, -0.38898787983164707, -0.3859987966215615, 
  -0.3845035508354982, -0.38375575184590455, -0.38338180832055596, 
  -0.3831948255494425, -0.38310133141167596, -0.38305458365472755, 
  -0.38300783543906436}, {-30.344756020501904, -28.958461196490177, 
  -27.57216590958861, -26.185869696913347, -24.79957163271465, 
  -23.413269865564867, -22.02696069289616, -20.64063671072271, 
  -19.25428311567393, -17.867870319424554, -16.48133921908203, 
  -15.094571904647337, -13.707333745301998, -12.319160284422905, 
  -10.929142215281207, -9.53554243959951, -8.135237352616183, 
  -6.723570578260052, -5.298815153964271, -3.889982108655837, 
  -2.6219700958470957, -1.6696226561357874, -1.070205140836852, 
  -0.7329577155359561, -0.5541080537843076, -0.4620260678914344, 
  -0.41530864193937694, -0.39177933502759293, -0.3799718495477569, 
  -0.3740573759995704, -0.3710974536820294, -0.3696168207827851, 
  -0.3688763363537532, -0.3685060521388507, -0.3683208995306109, 
  -0.3682283206012078, -0.36818203048017456, -0.3681357399215826}, {
  -30.356297251734578, -28.970002386220017, -27.583707016312665, 
  -26.197410637625374, -24.81111224140078, -23.42480981019187, 
  -22.03849930937552, -20.6521726707893, -19.265813762445177, 
  -17.879390337727177, -16.492837972945715, -15.10602809970753, 
  -13.718704703706393, -12.330360298624049, -10.93999850113226, 
  -9.545704276992216, -8.143985569187109, -6.729422989433339, 
  -5.298888679317727, -3.8805069009872666, -2.603597619399232, 
  -1.6486065425415233, -1.0505903694316086, -0.7153157048180571, 
  -0.537865784519915, -0.44659992518661523, -0.4003212831889839, 
  -0.3770192573946706, -0.36532741097233734, -0.35947125985925904, 
  -0.3565406248963531, -0.355074667260025, -0.3543415283652681, 
  -0.3539749188940094, -0.35379160415181843, -0.3536999442790088, 
  -0.3536541137171664, -0.35360828273836153}, {-30.36892678293045, 
  -28.982631875554645, -27.59633642192467, -26.2100398757916, 
  -24.82374114467334, -23.43743804366861, -22.051126203226744, 
  -20.664796885253946, -19.27843261759466, -17.891998472079486, 
  -16.505424657045637, -15.118571848745745, -13.731162445000578, 
  -12.342645478888896, -10.951936418054155, -9.55693945085961, 
  -8.153785528888742, -6.736264004113731, -5.299760788773502, 
  -3.8714275171645474, -2.5853384406462476, -1.6277522797884068, 
  -1.0312343766819556, -0.6979802133919378, -0.5219480779297343, 
  -0.4315049568026192, -0.3856676676304489, -0.36259400543059944, 
  -0.35101828654415573, -0.34522068862814215, -0.34231945299542876, 
  -0.3408682257539132, -0.34014245974484225, -0.3397795386392277, 
  -0.33959806856065083, -0.33950733113985737, -0.33946196183407673, 
  -0.3394165921313702}, {-30.382679031834748, -28.99638408226301, 
  -27.610088544241027, -26.223791829323343, -24.83749276063343, 
  -23.451188984475767, -22.064875793689467, -20.678543774873578, 
  -19.29217410491132, -17.905729152324113, -16.519133713290238, 
  -15.13223761763409, -13.74474148229854, -12.356050429963098, 
  -10.964990741758847, -9.569283022476512, -8.164672581345593, 
  -6.7441280097197795, -5.301456661358272, -3.862742309462112, 
  -2.567179656345745, -1.6070527007147013, -1.012131219248006, 
  -0.6809444151089777, -0.5063473387049987, -0.4167331324548541, 
  -0.3713395408740479, -0.34849521192373617, -0.3370360525676922, 
  -0.33129721036601567, -0.32842547191799454, -0.326989023143229, 
  -0.32627065384144877, -0.325911432958623, -0.3257318134588089, 
  -0.3256420014442499, -0.3255970948708007, -0.32555218791990265}, {
  -30.397592375851882, -29.01129738377439, -27.625001760740727, 
  -26.238704875799005, -24.85240546705831, -23.466101010788236, 
  -22.079786459733718, -20.693451720207864, -19.30707660813166, 
  -17.920620768541372, -16.534003544407838, -15.147063834236578, 
  -13.759480293079516, -12.370613725812552, -10.979200227245055, 
  -9.582774053267924, -8.176686114182628, -6.7530534238303614, 
  -5.304004728568285, -3.8544502294962157, -2.549108535051611, 
  -1.5865011202175017, -0.9932753467163823, -0.6642018371775291, 
  -0.4910563241182761, -0.4022767801336941, -0.35732901119863203, 
  -0.33471487490622087, -0.32337265197156684, -0.3176927404698982, 
  -0.31485058330223864, -0.3134289541887312, -0.3127180019776589, 
  -0.312362491455808, -0.3121847275904622, -0.3120958435066414, 
  -0.31205140092693884, -0.31200695798870587}, {-30.413709558867946, 
  -29.027414524000882, -27.64111881538788, -26.254821759286727, 
  -24.868522008224147, -23.482216867298217, -22.095900946883628, 
  -20.709563468444212, -19.323182877767316, -17.936716077882096, 
  -16.550076920790268, -15.16309329527553, -13.775421726104986, 
  -12.386378316661714, -10.994608016159804, -9.597456013127346, 
  -8.189869964143849, -6.763083107041756, -5.307436992566501, 
  -3.846550810809393, -2.531112498856933, -1.566091318884676, 
  -0.974661578273813, -0.6477463376039795, -0.4760681221080546, 
  -0.38812856436040694, -0.3436285278284646, -0.32124533592204196, 
  -0.31002037256706866, -0.30439953992646196, -0.3015870347348456, 
  -0.3001802597804279, -0.29947674169600286, -0.2991249499997927, 
  -0.29894904598791416, -0.2988610919409972, -0.2988171144072902, 
  -0.2987731365334157}, {-30.431078165531247, -29.044783087617965, 
  -27.658487292912316, -26.272190064625036, -24.88588996918686, 
  -23.499584139496363, -22.113266841499197, -20.726926607680785, 
  -19.34054050539063, -17.954062678858325, -16.567401454794176, 
  -15.180373640655459, -13.792613475792917, -12.403392003489794, 
  -11.011262111624562, -9.613377256240918, -8.20427289593224, 
  -6.774264843851251, -5.3117893968950245, -3.839044138163775, 
  -2.5131791083584063, -1.5458175279692912, -0.9562850808622984, 
  -0.6315720842431612, -0.46137613097710395, -0.3742814660504844, 
  -0.33023086081409064, -0.30807925989769924, -0.2969718269086625, 
  -0.2914101951661655, -0.2886273996016132, -0.28723550678635473, 
  -0.2865394366068042, -0.2861913705723414, -0.28601732981872463, 
  -0.28593030750779336, -0.28588679586879356, -0.2858432839074366}, {
  -30.449751175400216, -29.06345605421243, -27.677160172957556, 
  -26.2908627715709, -24.904562329930304, -23.518255807820303, 
  -22.13193712492543, -20.74559412107687, -19.35920247778748, 
  -17.97271356550122, -16.586030154909373, -15.198957907653654, 
  -13.811108636458385, -12.421707992393829, -11.029215932934852, 
  -9.63059157682739, -8.21994916119792, -6.786651904035576, -5.317102258941846
  , -3.8319308382926676, -2.4952960508747584, -1.525674415523807, 
  -0.9381413486814235, -0.6156735353204944, -0.44697404056487544, 
  -0.36072876384431307, -0.3171290823771803, -0.2952096164754368, 
  -0.2842199336164806, -0.27871759937910834, -0.27596455839966877, 
  -0.274587569362887, -0.273898957697526, -0.2735546225768294, 
  -0.2733824476943178, -0.27329635842250144, -0.2732533133289506, 
  -0.27321026793030373}, {-30.469787612263957, -29.083492447602964, 
  -27.697196479401416, -26.310898904120414, -24.924598114687125, 
  -23.53829089697573, -22.151970822814054, -20.765625036175795, 
  -19.37922782628264, -17.99272777669136, -16.6060220750994, 
  -15.218905180282675, -13.830966351725667, -12.441385544123557, 
  -11.048528965437908, -9.649158860099648, -8.23695915296102, 
  -6.800303699894236, -5.32342077548519, -3.825212058713932, 
  -2.4774511319668546, -1.5056570735255221, -0.9202261839181454, 
  -0.6000454213022332, -0.4328558147682496, -0.3474640167792059, 
  -0.30431654959338833, -0.28262966268314027, -0.27175790003491, 
  -0.2663149351667317, -0.26359168138541345, -0.26222961160073377, 
  -0.2615484659777642, -0.261207865482733, -0.26103755831422026, 
  -0.2609524029997004, -0.26090982490987286, -0.2608672465316665}, {
  -30.49125330761705, -29.104958099314928, -27.71866204383085, 
  -26.33236429398371, -24.9460631554138, -23.559755239411803, 
  -22.173433768599462, -20.78708518838205, -19.400682390219263, 
  -18.014171159643045, -16.627443078295844, -15.240281352806232, 
  -13.85225257809323, -12.462490737769288, -11.069267524569375, 
  -9.669145847429924, -8.255370174733013, -6.815286558409953, 
  -5.330795615257685, -3.8188894273312917, -2.459632270317496, 
  -1.4857610058376494, -0.9025356785974062, -0.5846827280025779, 
  -0.4190156752973915, -0.3344810481892867, -0.29178688829974925, 
  -0.2703329268274505, -0.25957920611386065, -0.25419565841596453, 
  -0.25150221244480775, -0.25015507139321097, -0.2494813963464995, 
  -0.24914453269236603, -0.2489760943325365, -0.2488918735194223, 
  -0.24884976270456433, -0.24880765161750532}, {-30.514221801974447, 
  -29.127926549895314, -27.74163040685693, -26.3553324819, -24.96903099310583
  , -23.582722376636568, -22.196399504814732, -20.810048122278456, 
  -19.423639718278356, -18.03711727122849, -16.650366737732337, 
  -15.26316003109427, -13.8750409863373, -12.485097372288278, 
  -11.091505657734132, -9.690627039404047, -8.275257347256856, 
  -6.831674632090613, -5.339283615789934, -3.8129650351904556, 
  -2.44182749603464, -1.4659821168624998, -0.885066197458559, 
  -0.5695806808274695, -0.4054480865645355, -0.3217739307308109, 
  -0.27953397812422515, -0.25831319350775506, -0.2476775894103966, 
  -0.24235348329351028, -0.23968985408369192, -0.23835764542451043, 
  -0.2376914425793203, -0.2373583165275728, -0.23719174734437987, 
  -0.23710846121344922, -0.23706681776315028, -0.2370251740562949}, {
  -30.53877541378196, -29.152480117823238, -27.766183887025356, 
  -26.379885786548176, -24.993583946708466, -23.60727462812799, 
  -22.22095035200319, -20.834596160538815, -19.448182137393676, 
  -18.061648446897276, -16.67487540587352, -15.287623601572594, 
  -13.899414030509265, -12.509288035624573, -11.115326213785833, 
  -9.713685766521149, -8.296704683955136, -6.849550978332992, 
  -5.348948606024814, -3.807441400886058, -2.424024952442246, 
  -1.4463167007546605, -0.8678143617729286, -0.5547347300645895, 
  -0.3921477416133368, -0.30933697244036357, -0.26755193854488446, 
  -0.24656448965858216, -0.23604703111828013, -0.23078236826784163, 
  -0.22814855344572207, -0.22683127518553106, -0.22617254334318454, 
  -0.2258431542439541, -0.22567845389982516, -0.22559610227913235, 
  -0.22555492610662878, -0.22551374969268737}, {-30.56500651357721, 
  -29.178711173670884, -27.792414854977462, -26.406116578707852, 
  -25.0198143872779, -23.633504365495405, -22.247178682880406, 
  -20.86082167809098, -19.474402026916934, -18.08785707484598, 
  -16.70106148859392, -15.313764505421839, -13.925464222181564, 
  -12.535155379076782, -11.140822117759067, -9.738415465192139, 
  -8.319806371453693, -6.869008845055827, -5.359862381637555, 
  -3.802321432595287, -2.4062129014182445, -1.4267614310728114, 
  -0.8507770340270717, -0.5401405371378303, -0.3791095490051996, 
  -0.2971647037421628, -0.2558351158949835, -0.23508107153670643, 
  -0.22468174304176725, -0.21947650307524538, -0.21687248927426575, 
  -0.215570133933636, -0.2149188691550898, -0.21459321498898587, 
  -0.21443038246175442, -0.2143489648370973, -0.2143082556845089, 
  -0.2142675463050808}, {-30.593019051432453, -29.20672366754638, 
  -27.8204272608931, -26.434128808702344, -25.047826265424355, 
  -23.661515539922842, -22.27518844977801, -20.888828629561697, 
  -19.502403346064735, -18.115847123469365, -16.72902897263803, 
  -15.341686766057103, -13.953295657973301, -12.562803644944685, 
  -11.168097898884472, -9.76492120706832, -8.344668304024214, 
  -6.890153210732331, -5.3721058670560184, -3.7976083837628494, 
  -2.3883797323286857, -1.40731335075926, -0.8339513034045216, 
  -0.5257939617522208, -0.3663286205868039, -0.2852518653285336, 
  -0.24437807123807972, -0.2238574125771427, -0.21357615543785077, 
  -0.2084302965541361, -0.20585605974248766, -0.2045686145205534, 
  -0.20392481020886588, -0.20360288762825685, -0.20344192123181268, 
  -0.20336143675706223, -0.20332119420055567, -0.2032809514312953}, {
  -30.62293039947582, -29.236634971615022, -27.85033847701191, 
  -26.464039848919963, -25.07773695383352, -23.691425524690725, 
  -22.305097027165896, -20.918734391799788, -19.532303476443722, 
  -18.14573598388958, -16.758895268158128, -15.371507831684628, 
  -13.983025862151827, -12.5923505092506, -11.1972715336821, 
  -9.793321543495164, -8.371409933506715, -6.913102640722638, 
  -5.3857705074140565, -3.793305801123233, -2.3705139745910633, 
  -1.3879698623462762, -0.8173344720061443, -0.5116910498621976, 
  -0.3538002600700317, -0.2735933968446571, -0.23317556904431438, 
  -0.2128881920492087, -0.20272490565815834, -0.19763836527885428, 
  -0.1950938710828412, -0.19382131801965288, -0.1931849650013278, 
  -0.19286676937105374, -0.19270766677571044, -0.19262811428299617, 
  -0.19258833773787928, -0.19254856099358997}, {-30.654873589740703, 
  -29.268578117948692, -27.88228153548276, -26.495982731663563, 
  -25.109679485116168, -23.72336735302572, -22.337037449502514, 
  -20.95067200172737, -19.564235459903717, -18.177656707813206, 
  -16.790793446579507, -15.403360813185222, -14.014788024559799, 
  -12.623929319784775, -11.228476684381404, -9.823750745339519, 
  -8.400166515027234, -6.937991540262295, -5.40095994587438, 
  -3.789417463587642, -2.3526043138778454, -1.3687287182981638, 
  -0.8009240417557821, -0.4978280224022824, -0.3415199523617584, 
  -0.26218442631493566, -0.22222256660529047, -0.20216828445012888, 
  -0.1921228275280005, -0.18709552293045373, -0.18458072695348057, 
  -0.1833230430901107, -0.1826941296952994, -0.18237965513281196, 
  -0.1822224133853856, -0.18214379139513742, -0.18206516866053704, 
  -0.18206516866053704}, {-30.68900005261317, -29.302704536973295, 
  -27.916407866811205, -26.530108887597994, -25.143805290255784, 
  -23.757492456548547, -22.37116114968314, -20.984792894789013, 
  -19.598350736988625, -18.211760745985856, -16.82487497906289, 
  -15.437397222594095, -14.048733739137335, -12.657691834743908, 
  -11.26186543793619, -9.856361543457822, -8.431091853810065, 
  -6.964972909480189, -5.417792058042835, -3.785947310349942, 
  -2.3346396119434387, -1.3495880114075283, -0.7847177019436962, 
  -0.4842012647247476, -0.329483353586566, -0.25102026025398944, 
  -0.2115142041306162, -0.19169274957929064, -0.18176494140570273, 
  -0.1767967703476294, -0.17431161848475005, -0.17306877602111703, 
  -0.17244728816266933, -0.17213652757759046, -0.1719811431211878, 
  -0.17190344985203304, -0.17182575588891422, -0.17182575588891422}, {
  -30.72548299548704, -29.339187436123815, -27.952890678514578, 
  -26.566591524405293, -25.180287577263805, -23.793974043929474, 
  -22.407641337695757, -21.021270283608438, -19.634822525594842, 
  -18.24822132685402, -16.861313115173655, -15.473790351786684, 
  -14.085036382648592, -12.693811601571886, -11.2976116852425, 
  -9.89132850941225, -8.464361692724992, -6.994221740148092, 
  -5.4364014371664515, -3.7828993563780986, -2.316608930024361, 
  -1.3305461651736694, -0.7687133173655261, -0.4708073166937759, 
  -0.3176862817504817, -0.24009637441033627, -0.20104579547422935, 
  -0.18145682324131648, -0.17164644487041408, -0.16673728620598272, 
  -0.1642817149539541, -0.16305368140434337, -0.16243960265569074, 
  -0.16213254778878425, -0.1619790164822964, -0.1619022498608074, 
  -0.16182548259382737, -0.16182548259382737}, {-30.764521608994844, 
  -29.37822600607532, -27.991929161353017, -26.60562983301573, 
  -25.21932553741077, -23.833011307119623, -22.44667720685276, 
  -21.060303364220992, -19.673850027205283, -18.287237662802344, 
  -16.90030708912605, -15.512739478738457, -14.123895320977416, 
  -12.732488163262422, -11.335915324418995, -9.92885214768537, 
  -8.500173942418078, -7.025939241597143, -5.456942453798013, 
  -3.7802775932633867, -2.298501555723479, -1.311601924100263, 
  -0.7529089170191119, -0.4576428633900676, -0.3061247079983615, 
  -0.22940840509535565, -0.19081281944319425, -0.17145590853068843, 
  -0.1617627039911409, -0.1569124182783937, -0.15448635504117741, 
  -0.15327309338743403, -0.1526664050592934, -0.1523630465208458, 
  -0.152211363658145, -0.15213552132844016, -0.1520596783998377, 
  -0.1520596783998377}, {-30.806346355564852, -29.42005070929998, 
  -28.033753777886496, -26.647454276164897, -25.26114963378352, 
  -23.874834709908352, -22.488499222348665, -21.10212260463207, 
  -19.71566371544924, -18.329040238716498, -16.942087408352478, 
  -15.55447515610942, -14.165541197765245, -12.773952347627349, 
  -11.377007567445517, -9.96916476693844, -8.538773907670993, 
  -7.060358150569495, -5.479593055071876, -3.7780858731764866, 
  -2.2803070332451925, -1.292754343858577, -0.7373026833256336, 
  -0.44470472638379666, -0.29479474842161085, -0.21895214105424446, 
  -0.18081091164574165, -0.1616855676547375, -0.15210924513385088, 
  -0.14731767523334555, -0.1449210386230145, -0.1437225074653852, 
  -0.14312318868127796, -0.14282351598887927, -0.14267367631771596, 
  -0.1425987556509087, -0.14252383442995673, -0.14252383442995673}, {
  -30.851225691625288, -29.464930002271306, -28.078632984679096, 
  -26.692333310598016, -25.30602832348956, -23.91971271012777, 
  -22.533375843464967, -21.146996467022596, -19.760532058309177, 
  -18.37389753419266, -16.986922575718914, -15.59926593347221, 
  -14.210242656642015, -12.818472988587878, -11.421157627835962, 
  -10.01253604323151, -8.580421164758423, -7.097749476255971, 
  -5.504559526855647, -3.776327773480199, -2.2620151968029227, 
  -1.2740027812714763, -0.7218929418451945, -0.4319898555374241, 
  -0.2836926563766232, -0.2087235158393687, -0.1710358568390442, 
  -0.15214151425553843, -0.1426817472672024, -0.13794871893177454, 
  -0.1355814190647827, -0.1343975727703886, -0.1338056005409601, 
  -0.13350960215668697, -0.13336159989728583, -0.13328759800078463, 
  -0.13321359559308887, -0.13321359559308887}, {-30.899474715581896, 
  -29.513178983441712, -28.12688188027657, -26.740582035047527, 
  -25.35427670563472, -23.967960407630546, -22.581622171548226, 
  -21.19524005572769, -19.80877016610056, -18.42212467151983, 
  -17.035127737512543, -15.64742700531332, -14.258314989292673, 
  -12.866365575385762, -11.468681404207018, -10.05928283132159, 
  -8.625438076272845, -7.138431172422092, -5.532082524758377, 
  -3.7750064393079605, -2.243616206958579, -1.2553468840820732, 
  -0.7066781514601718, -0.41949532130304423, -0.2728148152776087, 
  -0.19871860064973987, -0.16148358174053615, -0.14281960619456, 
  -0.13347603473077752, -0.12880135718633212, -0.1264632959751076, 
  -0.12529408482403462, -0.12470943412017038, -0.12441709748716101, 
  -0.12427092635051286, -0.12419784007716837, -0.12412475333381659, 
  -0.12412475333381659}, {-30.95146644292075, -29.565170668345342, 
  -28.178873480309207, -26.792573465335995, -25.406267796426135, 
  -24.019950819393006, -22.633611225113384, -21.2472263923405, 
  -19.86075106657671, -18.474094690786817, -17.08707595855353, 
  -15.699331486155696, -14.310131410594096, -12.918003527293719, 
  -11.519952738354087, -10.10977986138711, -8.674201150493879, 
  -7.182779437486282, -5.562444799566417, -3.7741244012125312, 
  -2.2251005896163774, -1.236786580479531, -0.6916568950025638, 
  -0.4072183074818802, -0.26215773183050756, -0.18893359760337927, 
  -0.15215014826963194, -0.133715838766975, -0.12448807043273515, 
  -0.1198715369499845, -0.11756260838981568, -0.11640797871880329, 
  -0.11583062254353675, -0.11554193412195994, -0.11539758732781014, 
  -0.11532541328491051, -0.11525323881146692, -0.11525323881146692}, {
  -31.00764672727267, -29.621350910662482, -28.235053638556224, 
  -26.84875345544052, -25.4624474502367, -24.076129800579704, 
  -22.68978886090856, -21.303401336777384, -19.916920625994873, 
  -18.53025347095016, -17.143213143267076, -15.755425331640971, 
  -14.36613797972839, -12.97383311492339, -11.575418340310398, 
  -10.164474778404012, -8.727159960757065, -7.231243660445432, 
  -5.595981219110156, -3.7736833647664323, -2.206459277325492, 
  -1.2183220683626532, -0.6768278703040236, -0.3951561044161158, 
  -0.2517180296773825, -0.17936483341206272, -0.14303174718941739, 
  -0.12482633831523939, -0.11571394944652552, -0.11115533790359954, 
  -0.10887542835478872, -0.10773532269851244, -0.10716523215771467, 
  -0.10688017746012672, -0.10673764775465727, -0.10666638231276908, 
  -0.10659511647811765, -0.10659511647811765}, {-31.06855433942108, 
  -29.682258481227432, -28.29596112595368, -26.90966077650069, 
  -25.523354438613044, -24.13703612355145, -22.75069385292327, 
  -21.36430366628649, -19.977817628125468, -18.591139808844922, 
  -17.20407811469763, -15.816247417552391, -14.426873679230777, 
  -13.034393539357426, -11.635617867820454, -10.223908223345967, 
  -8.784857237973867, -7.284366522903984, -5.633091953398412, 
  -3.773683968808596, -2.187683652489302, -1.1999538043298748, 
  -0.6621898816495233, -0.3833061025856314, -0.2414924434231489, 
  -0.17000875343041133, -0.13412469212037495, -0.11614735621405403, 
  -0.10714989297878577, -0.10264896641465768, -0.10039795487991607, 
  -0.09927231210984928, -0.09870945648169999, -0.09842802010779082, 
  -0.09828729978099608, -0.0982169390826531, -0.0981465780276856, 
  -0.0981465780276856}, {-31.134848502562416, -29.74855260328893, 
  -28.362255165854897, -26.975954652078972, -25.589647985536, 
  -24.203329013125867, -22.81698542764905, -21.430592610708633, 
  -20.04410130951355, -18.657412954447263, -17.270330149774264, 
  -15.882457075087405, -14.492997950284028, -13.100344467521335, 
  -11.701211462040018, -10.28874137061999, -8.847956420192622, 
  -7.34281155241097, -5.674260097161064, -3.774125508876319, 
  -2.168765592035128, -1.1816824923917852, -0.6477418316174841, 
  -0.37166578658433275, -0.2314778130187312, -0.16086191605354425, 
  -0.12542541390045134, -0.10767526320105404, -0.0987922426827967, 
  -0.09434874984146403, -0.09212650823853247, -0.0910152636993825, 
  -0.09045961050261962, -0.09018177617334548, -0.09004285707609823, 
  -0.08997339704433606, -0.0899039366904871, -0.0899039366904871}, {
  -31.207347473579446, -29.821051533783425, -28.43475401530373, 
  -27.048453339434058, -25.662146348693916, -24.275826727850724, 
  -22.889481845352936, -21.503086433750934, -20.116589940752746, 
  -18.72989119214923, -17.34278756058746, -15.95487267214011, 
  -14.56532927401938, -13.172504613554333, -11.773018329219198, 
  -10.359794511484013, -8.917280248984545, -7.407401711279473, 
  -5.720075645891702, -3.775005622219877, -2.1496975130396287, 
  -1.1635090724095067, -0.633482713290929, -0.36023272945268153, 
  -0.2216710784767703, -0.151920987439566, -0.11693045526782714, 
  -0.09940654402963367, -0.09063745529391252, -0.0862511311592934, 
  -0.08405752458877534, -0.08296061023248849, -0.08241212529343285, 
  -0.0821378758845323, -0.08200074944534581, -0.08193218579208193, 
  -0.08186362184970926, -0.08186362184970926}, {-31.287083953828752, 
  -29.900787974122633, -28.514490375822128, -27.12818954030837, 
  -25.741882230270193, -24.355561970791516, -22.969215810865013, 
  -21.582817843774446, -20.196316237273084, -18.80960725154699, 
  -17.422483105178543, -16.03452702409473, -14.64490058232487, 
  -13.251907149679253, -11.85207215186573, -10.438102466931841, 
  -8.99386619617479, -7.479174794205738, -5.771268781646727, 
  -3.7763199308749518, -2.130472418873163, -1.1454347082688636, 
  -0.6194116028256115, -0.3490045873447944, -0.21206927489783595, 
  -0.1431827365350003, -0.10863646584460346, -0.0913377924221564, 
  -0.08268209756524554, -0.07835266388675118, -0.07618755089514478, 
  -0.0751048954124801, -0.07456354293083334, -0.07429286050573139, 
  -0.07415751774721062, -0.07408984598147035, -0.07402217395808158, 
  -0.07402217395808158}, {-31.375386986616036, -29.989090967668783, 
  -28.602793290885383, -27.216492298403335, -25.830184674418575, 
  -24.443863787006702, -23.057516371053683, -21.67111589126939, 
  -20.284609256816182, -18.89789020491603, -17.510745885015286, 
  -16.12274929130344, -14.73304115533412, -13.33988160374378, 
  -11.939702986557458, -10.524996487200658, -9.079048378099543, 
  -7.559465272822286, -5.828757165508995, -3.7780616390510633, 
  -2.111083944496813, -1.127460775806548, -0.6055276523623974, 
  -0.3379790945100546, -0.20266952778679864, -0.13464403038299821, 
  -0.10054019740132103, -0.08346570630351371, -0.0749228414835774, 
  -0.07065000729233609, -0.06851324013026275, -0.06744476907992779, 
  -0.06691051169334757, -0.0666433775354427, -0.06650980909042906, 
  -0.06644302452641851, -0.06637623973474313, -0.06637623973474313}, {
  -31.474007154071277, -30.087711096609794, -28.701413342797306, 
  -27.31511219625455, -25.92880426413825, -24.542482760422814, 
  -23.156134111700684, -21.769731165730036, -20.383219596309885, 
  -18.996490664085414, -17.609326541865656, -16.221290175960526, 
  -14.831501818307261, -13.438179056143696, -12.037662461111209, 
  -10.622229450592265, -9.174582770098384, -7.650029363002102, 
  -5.893714954227663, -3.780221081666379, -2.091526402628414, 
  -1.1095888505100366, -0.5918300832721909, -0.32715405857062024, 
  -0.1934690486405371, -0.1263018296956763, -0.09263849938376868, 
  -0.07578708329652889, -0.06735645974701258, -0.06313992186272302, 
  -0.06103134673834951, -0.05997698267370536, -0.05944978152115349, 
  -0.05918617616549306, -0.05905437229290075, -0.05898847005792459, 
  -0.058922567623832536, -0.058922567623832536}, {-31.585315826059542, 
  -30.199019730870088, -28.81272190160102, -27.426420604142557, 
  -26.040112370184637, -24.653790262745154, -23.26744040641167, 
  -21.881035044565056, -20.49451864077817, -19.107780029346785, 
  -17.72059650670546, -16.332521171008423, -14.94265419053927, 
  -13.549171388762522, -12.148323023738554, -10.73217511421985, 
  -9.282846473854535, -7.753243992509363, -5.96767672647881, 
  -3.7827852208699375, -2.0717948262432473, -1.091820695018109, 
  -0.5783181797226364, -0.3165273560775136, -0.18446513078954602, 
  -0.11815318467336218, -0.08492831468495042, -0.06829881646211008, 
  -0.05997982148730418, -0.0558192650157074, -0.05373872234336092, 
  -0.05269838493669418, -0.05217819972056483, -0.05191810298490467, 
  -0.0517880535852512, -0.051723028627477886, -0.05165800349774387, 
  -0.05165800349774387}, {-31.712638159539534, -30.32634202746912, 
  -28.94004412443749, -27.553742679451343, -26.16743415042782, 
  -24.781111452816155, -23.394760415974396, -22.008352692455357, 
  -20.62183156269826, -19.23508348881023, -17.847880999071773, 
  -16.45976755948748, -15.069823684707263, -13.676184284338039, 
  -12.275010942594774, -10.858161115065116, -9.407170735952029, 
  -7.872439204887565, -6.052699904475214, -3.7857370882510053, 
  -2.0518850106589825, -1.0741582464532682, -0.5649912825565915, 
  -0.3060969283291881, -0.17565514547732036, -0.11019523105481398, 
  -0.07740667564637496, -0.06099789026835995, -0.05278988822106168, 
  -0.04868498704202737, -0.04663231168601212, -0.04560591785038148, 
  -0.04509270689740804, -0.0448360979126624, -0.04470779254329136, 
  -0.044643639639364414, -0.044579486589279814, -0.044579486589279814}, {
  -31.860844536929125, -30.474548368886914, -29.08825039391104, 
  -27.701948805033847, -26.315639988217992, -24.9293167149807, 
  -23.542964526723797, -22.156554499718677, -20.77002876036434, 
  -19.383271456766142, -17.996050465421444, -16.607899852888607, 
  -15.217880945215512, -13.824088664813393, -12.422597744274205, 
  -11.005060409874257, -9.552432406130556, -8.012488306013589, 
  -6.1516302358520365, -3.789055171169738, -2.031793552160394, 
  -1.0566036036211233, -0.5518487834729994, -0.29586077743752787, 
  -0.16703653816252048, -0.10242518638364025, -0.07007070027399491, 
  -0.053881376774010704, -0.045783710015237226, -0.041734127261465484, 
  -0.0397091487750868, -0.038696612783748356, -0.03819033310469233, 
  -0.037937190344773795, -0.037810618234773954, -0.03774733199727108, 
  -0.03768404563810207, -0.03768404563810207}, {-32.03748613057028, 
  -30.651189927528957, -29.26489188255423, -27.878590153676782, 
  -26.49228105685022, -25.105957223550735, -23.71960391500631, 
  -22.333191646773333, -20.946661422350086, -19.559895138145478, 
  -18.1726561435869, -16.78446935560085, -15.39437741263001, 
  -14.000436255763484, -12.598635778337764, -11.18042684095026, 
  -9.726189522214447, -8.18094044685123, -6.2685603679600765, 
  -3.79271274290964, -2.0115178834581657, -1.039159014115045, 
  -0.5388901195013426, -0.28581696262725764, -0.15860682503003223, 
  -0.09484034647727033, -0.06291758865522641, -0.04694643201264387, 
  -0.038958421853360556, -0.03496381037971129, -0.03296635323951871, 
  -0.03196758684293793, -0.03146819419106902, -0.03121849550211998, 
  -0.031093645566939422, -0.031031220451678467, -0.03096879523797284, 
  -0.03096879523797284}, {-32.255213769457264, -30.868917532454432, 
  -29.48261941955606, -28.096317554828794, -26.710008186292498, 
  -25.323683809533154, -23.93732941390739, -22.55091497086501, 
  -21.164380394234048, -19.777605395242286, -18.39034892949309, 
  -17.00212703161774, -15.61196419036596, -14.217878453058796, 
  -12.81577708402958, -11.396914003966383, -9.941100197702248, 
  -8.390431824469593, -6.4096791832696445, -3.796677138567089, 
  -1.991056305038522, -1.021826861366834, -0.5261147677612559, 
  -0.2759635967556203, -0.15036358969799507, -0.08743808208576016, 
  -0.05594461956444947, -0.04019029256513902, -0.032311240189981466, 
  -0.028371243033444828, -0.026401126868711686, -0.025416039409171767, 
  -0.024923488337537117, -0.02467721096655709, -0.024554071822314224, 
  -0.02449250213550928, -0.02443093237225066, -0.02443093237225066}, {
  -32.53774381923939, -31.151447549378922, -29.765149370764654, 
  -28.378847374603104, -26.992537743188297, -25.606212840632118, 
  -24.21985739325341, -22.833440846067802, -21.446902058598997, 
  -20.060118627709656, -18.672845257146722, -17.28458938451328, 
  -15.894357924638806, -14.500132202776078, -13.097739270186453, 
  -11.678241128768091, -10.220888522774077, -8.664628271288322, 
  -6.584995246673641, -3.8009089791872843, -1.9704080120065712, 
  -1.0046096516860812, -0.5135222404992655, -0.26629884304003326, 
  -0.14230448010878405, -0.08021583572867151, -0.04914914724530403, 
  -0.03361027230869896, -0.02583945968168382, -0.021953710512017513, 
  -0.02001075032947071, -0.01903924885328678, -0.01855349277078055, 
  -0.01831061339365053, -0.018189173371144646, -0.018128453276409967, 
  -0.01806773312602208, -0.01806773312602208}, {-32.93832076004222, 
  -31.552024458495595, -30.16572621650841, -28.7794240935986, 
  -27.393114208677513, -26.006788799069767, -24.620432337431875, 
  -23.23401376110346, -21.847470912849154, -20.460679350372992, 
  -19.073389676441593, -17.685101035231387, -16.29480338222215, 
  -14.900442578897888, -13.497768092876163, -12.07765565765842, 
  -10.618807162863577, -9.056594062670234, -6.812301067161772, 
  -3.8053613539427134, -1.9495731158237595, -0.9875100013321023, 
  -0.5011120803948617, -0.2568209119821881, -0.13442720559275578, 
  -0.07317111869907544, -0.04252859835893192, -0.027203759331637985, 
  -0.019540450083870068, -0.015708573644930023, -0.013792580048753753, 
  -0.012834569416105586, -0.012355560642342712, -0.012116055391251563, 
  -0.011996302549672174, -0.011936426074876483, -0.011876549564077708, 
  -0.011876549564077708}, {-33.626843720076316, -32.240547388083975, 
  -30.854249085204746, -29.46794684050848, -28.081636712004986, 
  -26.69531081519446, -25.30895337899911, -23.922532852947892, 
  -22.535986102814476, -21.14918672682973, -19.76188138674905, 
  -18.373561255657634, -16.983199983981084, -15.58870931676817, 
  -14.18576398872536, -12.765059779081342, -11.304763912511657, 
  -9.735262078765142, -7.12814907749566, -3.8099789665478085, 
  -1.9285526604655439, -0.9705306236629844, -0.4888838561283601, 
  -0.2475280584777647, -0.12672953409434626, -0.06630150822450692, 
  -0.03608046908808234, -0.020968213003885763, -0.013411653303284032, 
  -0.009633265845083266, -0.007744045252219258, -0.00679942824461468, 
  -0.006327118063614838, -0.006090962553889968, -0.00597288469423041, 
  -0.0059138457382026275, -0.0058548067647099565, -0.0058548067647099565}}
;

  
double mlf_lookupa1[NROWS][NCOLS] = {{-14.514513042286982, -13.821366358724841, -13.128220172159766, 
  -12.435074979586599, -11.741931774988355, -11.048792546304405, 
  -10.355661269306818, -9.6625458951131, -8.969462324251863, -8.27644235095615
  , -7.583549536406328, -6.890910893908317, -6.198780014558121, 
  -5.5076623440932675, -4.8185618727492665, -4.133459328046541, 
  -3.4562098973092166, -2.794119744094677, -2.160335435252867, 
  -1.5762874740545196, -1.0710490100830907, -0.672532733735184, 
  -0.39176067096389655, -0.2149393171267972, -0.11323193484747666, 
  -0.05821733172506054, -0.029532133581146588, -0.014875046858421349, 
  -0.007465172713895581, -0.003739550199086936, -0.0018715225632992725, 
  -0.0009361989644789689, -0.00046820900530875173, -0.0002341318962327876, 
  -0.00011707279811336422, -0.00005853811175617128, -0.00002926948407803272, 
  0.}, {-14.520534781850223, -13.82738809505196, -13.134241902014649, 
  -12.441096696497048, -11.747953466010111, -11.054814185549436, 
  -10.36168280500106, -9.668567223716398, -8.975483238715817, 
  -8.282462437311557, -7.589567967224863, -6.896926016371417, 
  -6.2047885311628495, -5.513657692226126, -4.824531055607509, 
  -4.139376856717369, -3.462026743137608, -2.7997451260724873, 
  -2.165613245120374, -1.5809845016903028, -1.07489815983785, 
  -0.6753601170928547, -0.3936070162304262, -0.21602905838359374, 
  -0.11383077628525226, -0.058532342755580974, -0.02969384736998881, 
  -0.014956998292843611, -0.00750642762496135, -0.003760248164342791, 
  -0.0018818892633161632, -0.000941386755146125, -0.00047080401222502423, 
  -0.0002354296777640216, -0.00011772175841938728, -0.00005886260929725345, 
  -0.000029431737195830527, 0.}, {-14.52672596193754, -13.833579271664652, 
  -13.140433071678105, -12.44728785226208, -11.754144593978475, 
  -11.061005257925206, -10.367873766194608, -9.67475796255735, 
  -8.981673532898974, -8.288651842368647, -7.59575559478757, 
  -6.9031100919733515, -6.210965514931396, -5.519820540490715, 
  -4.830665824009585, -4.145456218127513, -3.4679982097782522, 
  -2.8055117922491233, -2.1710094110430584, -1.5857653478399178, 
  -1.078789499408089, -0.6781941074814197, -0.3954417251903052, 
  -0.21710439238648557, -0.11441893725686302, -0.05884088030435116, 
  -0.02985199846018654, -0.015037080782905337, -0.0075467253465623515, 
  -0.0037804617495263235, -0.0018920123134699939, -0.0009464523542231652, 
  -0.00047333783146791107, -0.00023669684246239206, -0.00011835540455660618, 
  -0.0000591794483151799, -0.000029590160692383593, 0.}, {-14.533089157466474
  , -13.839942463476298, -13.146796256055186, -12.453651021770082, 
  -11.76050773374852, -11.06736833822016, -10.374236727542648, 
  -9.681120686024649, -8.988035780657126, -8.295013138917804, 
  -7.6021149897554885, -6.90946568712242, -6.2173135237903026, 
  -5.526153429944474, -4.836968685648683, -4.151699854708424, 
  -3.474126614781319, -2.8114218312990795, -2.176525635714182, 
  -1.5906311576441818, -1.0827235595028744, -0.6810347974103043, 
  -0.3972647341838801, -0.2181652580192199, -0.11499638609900356, 
  -0.05914293051194748, -0.030006580884626623, -0.015115291661766882, 
  -0.007586064635298852, -0.0038001903568902298, -0.0019018914210620897, 
  -0.0009513956169282193, -0.0004758103910415544, -0.0002379333544288327, 
  -0.00011897371860031588, -0.000059488619854185216, -0.000029744750091428916
  , 0.}, {-14.53962701636811, -13.846480318413851, -13.153334103064587, 
  -12.460188852923238, -11.76704553318941, -11.073906074237415, 
  -10.380774336716218, -9.687658041525191, -8.994572628868976, 
  -8.301548972781669, -7.608648795840497, -6.9159954413144105, 
  -6.2238351888248244, -5.53265897493788, -4.84344222174798, 
  -4.158110282775137, -3.480414349854807, -2.817477405204066, 
  -2.1821636898283385, -1.5955831283399071, -1.0867008949458599, 
  -0.6838822786263293, -0.3990759721467408, -0.21921159074047566, 
  -0.11556309109248981, -0.059438480380824006, -0.030157589423244625, 
  -0.015191628729941765, -0.007624444506989035, -0.0038194335249579383, 
  -0.0019115263632307204, -0.000956216433828188, -0.0004782216367320348, 
  -0.00023913918668247392, -0.00011957668709165649, -0.00005979011719246043, 
  -0.000029895502033995614, 0.}, {-14.546342262553273, -13.853195560384052, 
  -13.16004933660488, -12.466904069603775, -11.77376071615068, 
  -11.080621189761123, -10.387489317368711, -9.694372752450874, 
  -9.001286800403507, -8.3082620657837, -7.615359732776228, -6.922702070108148
  , -6.230533217263586, -5.539339866116516, -4.850089090094529, 
  -4.164690095612513, -3.486863884015331, -2.8236807524067378, 
  -2.187925414936189, -1.6006225111495356, -1.0907220851375548, 
  -0.6867366418433863, -0.4008753605055628, -0.22024332264742222, 
  -0.11611902050907974, -0.05972751778573798, -0.03030501960025176, 
  -0.015266090251033171, -0.007661864233684876, -0.00383819092680095, 
  -0.0019209169860286031, -0.000960914730360783, -0.0004805715318655906, 
  -0.0002403143210391076, -0.00012016430097633744, -0.00006008393581262324, 
  -0.00003004241426363951, 0.}, {-14.553237699034563, -13.860090992395461, 
  -13.166944759676541, -12.473799474796008, -11.780656085584322, 
  -11.08751648767864, -10.394384472258205, -9.701267621301234, 
  -9.008181097243236, -8.315155218872645, -7.622250599444947, 
  -6.929588368257178, -6.23741039561963, -5.5461988735800825, 
  -4.856912028231113, -4.171441966721041, -3.493477766900283, 
  -2.8300341911247155, -2.1938127264447638, -1.60575061326956, 
  -1.0947877345454102, -0.6895979764638089, -0.4026628130710502, 
  -0.22126038254103642, -0.11666414265928193, -0.060010031484382456, 
  -0.03044886768133891, -0.015338674947423503, -0.0076983233406550935, 
  -0.0038564623682954932, -0.0019300632034914224, -0.0009654904663550451, 
  -0.0004828600570634849, -0.00024145874798642633, -0.00012073655554324944, 
  -0.000060370073369967416, -0.000030185485611011502, 0.}, {-14.56031621121423
  , -13.867169499846337, -13.174023257669855, -12.480877953874264, 
  -11.787734526832752, -11.094594853268555, -10.401462686535645, 
  -9.708345532971942, -9.015258403773341, -8.322231315412921, 
  -7.629324277170436, -6.936657213007584, -6.2444695929979135, 
  -5.553238850208423, -4.8639138568161036, -4.17836865323234, 
  -3.5002586322515903, -2.8365401228352014, -2.1998276167730824, 
  -1.610968799964345, -1.0988984732227232, -0.6924663702904411, 
  -0.40443823592817973, -0.22226269599337353, -0.11719842594113711, 
  -0.06028601112818594, -0.030589130670848425, -0.015409381995920296, 
  -0.007733821603338732, -0.0038742477863640875, -0.0019389649966959242, 
  -0.0009699436355432273, -0.0004850872099957425, -0.00024257246656092383, 
  -0.00012129345036063236, -0.00006064852966160007, -0.00003032471597742659, 
  0.}, {-14.56758077034868, -13.874434053989155, -13.181287801829427, 
  -12.488142478067422, -11.794999011093383, -11.101859257665357, 
  -10.408726931209673, -9.715609458219955, -9.022521690247464, 
  -8.329493324651706, -7.636583733187661, -6.943911567572744, 
  -6.251713764580039, -5.560462735165337, -4.87109748316217, 
  -4.185472999505183, -3.5072092015820333, -2.843201035941238, 
  -2.205972158673552, -1.616278496772385, -1.1030549573573865, 
  -0.6953419092284935, -0.40620152732397624, -0.2232501854169724, 
  -0.11772183888993389, -0.06055544727324932, -0.030725806308905132, 
  -0.015478211023350275, -0.0077683590442667195, -0.0038915472471989, 
  -0.0019476224128114855, -0.0009742742650714926, -0.0004872530051313133, 
  -0.00024365548422190306, -0.00012183498921435167, -0.00006091930659435735, 
  -0.000030460106320431317, 0.}, {-14.575034437201237, -13.881887715583368, 
  -13.188741452906967, -12.495596108111704, -11.80245259907147, 
  -11.109312761512358, -10.416180266799719, -9.723062457316953, 
  -9.029974016441798, -8.336944305374367, -7.644032024300844, 
  -6.9513544847966555, -6.259145955297835, -5.5678735575918346, 
  -4.878465904965477, -4.192757940913802, -3.514332288035947, 
  -2.850019509631437, -2.212248508596926, -1.6216810685086158, 
  -1.1071524040562937, -0.6982246769762152, -0.40795257755303405, 
  -0.2242227701365951, -0.11823435022884575, -0.06081833139137857, 
  -0.030858893068491024, -0.015545162102105745, -0.007801935929955259, 
  -0.003908360944470375, -0.001956035564141264, -0.0009784824150043119, 
  -0.0004893574734866618, -0.00024470781672425814, -0.00012236118004406383, 
  -0.00006118240815327497, -0.000030591658635818294, 0.}, {-14.582680365895706
  , -13.889533638748972, -13.196387365014868, -12.503241998104277, 
  -11.810098444833745, -11.11695851881542, -10.423825847189898, 
  -9.730707683903564, -9.03761853551003, -8.34458740976076, -7.651672300742494
  , -6.958989111018353, -6.2667693037083545, -5.575474440501377, 
  -4.8860222142379595, -4.200226507841057, -3.5216308004570522, 
  -2.8569982179469964, -2.21865891104761, -1.6271784383385859, 
  -1.111507920933072, -0.7011147547033716, -0.4096912688410695, 
  -0.22518036646346665, -0.11873592892044843, -0.06107465588118709, 
  -0.030988390152453683, -0.01561023574563874, -0.007834552767767877, 
  -0.0039246891975196945, -0.0019642046271566094, -0.0009825681778273445, 
  -0.0004914006623725606, -0.0002457294879915847, -0.00012287203487804845, 
  -0.0000614378403698364, -0.00003071937594397067, 0.}, {-14.590521807984212, 
  -13.897375075034365, -13.204228789694056, -12.51108339957115, 
  -11.817939799876353, -11.12479978101097, -10.431666923697211, 
  -9.738548389057929, -9.045458498052575, -8.352425887455896, 
  -7.659507810246877, -6.966818690150943, -6.274587046083781, 
  -5.583268604890627, -4.893769601456198, -4.207881829890095, 
  -3.529107747677143, -2.8641399340669857, -2.2252057011385666, 
  -1.632771857130086, -1.1158058488005411, -0.7040122207164962, 
  -0.41141747522678346, -0.22612288777220899, -0.11922654421908833, 
  -0.061324414079225044, -0.031114297490437513, -0.015673432903899494, 
  -0.007866210302751324, -0.003940532449537443, -0.001972129841524961, 
  -0.0009865316779433572, -0.0004933826351398665, -0.0002467205299867315, 
  -0.00012336756977037055, -0.00006168561128855527, -0.00003084326227121037, 
  0.}, {-14.598562116743965, -13.9054153777131, -13.21226908021078, 
  -12.51912366576395, -11.82598001742169, -11.132839901262935, 
  -10.439706849368651, -9.746587925593166, -9.053497256414808, 
  -8.360463089869594, -7.667541902352557, -6.974846567989846, 
  -6.2826025207308565, -5.591259374080321, -4.90171135994155, 
  -4.215727140329185, -3.5367662430404776, -2.8714475348317285, 
  -2.231891310033111, -1.6384631394300806, -1.1201524203019149, 
  -0.7069171501098624, -0.41313106244235254, -0.22705024458062714, 
  -0.1197061657240605, -0.061567600271108025, -0.031236615735728883, 
  -0.015734754958723778, -0.007896909514442147, -0.003955891265728473, 
  -0.0019798115091297875, -0.0009903730711676253, -0.0004953034709211684, 
  -0.00024768098258356954, -0.0001238478047346001, -0.0000619257309357782, 
  -0.00003096332263603139, 0.}, {-14.606804751718663, -13.913658006325305, 
  -13.220511696098026, -12.52736625620138, -11.834222556959899, 
  -11.141082339004338, -10.447949083522985, -9.754829752599537, 
  -9.06173826922994, -8.368702474720877, -7.67577803294975, -6.983076196766027
  , -6.290819172555614, -5.599450178302049, -4.909850890487328, 
  -4.2237657807856, -3.5446095091798875, -2.878924005515634, 
  -2.2387182686157794, -1.6442540497384879, -1.1245484316483647, 
  -0.7098296144011074, -0.4148318877928969, -0.22796234463252632, 
  -0.12017476343356277, -0.06180420970260684, -0.03135534626200189, 
  -0.01579420371916365, -0.00792665161364613, -0.003970766331463684, 
  -0.001987249993085251, -0.0009940925442198224, -0.0004971632643738618, 
  -0.0002486108934358685, -0.00012431276367897348, -0.00006215821128604458, 
  -0.00003107956303044789, 0.}, {-14.615253283521639, -13.922106531480834, 
  -13.22896020795869, -12.535814741472416, -11.842670989052111, 
  -11.14953066474062, -10.45639719655428, -9.763277440248345, 
  -9.070185106223702, -8.377147610844162, -7.6842197690895695, 
  -6.9915111399612675, -6.299240557890459, -5.607844559548002, 
  -4.918191706250128, -4.232001206205703, -3.552640883061925, 
  -2.8865724448699033, -2.245689212212709, -1.6501464288920804, 
  -1.128994709171916, -0.7127496811503704, -0.41651980003529737, 
  -0.22885909298371662, -0.12063230779937319, -0.06203423859066803, 
  -0.031470491159958265, -0.015851781416759102, -0.00795543803919458, 
  -0.003985158450420053, -0.00199444571674426, -0.000997690314212171, 
  -0.0004989621254196516, -0.00024951031784716936, -0.00012476247434122114, 
  -0.00006238306622922337, -0.000031191990404784016, 0.}, {-14.623911398919192
  , -13.930764639942602, -13.237618302548912, -12.544472808319664, 
  -11.851329000413859, -11.158188565133164, -10.465054875015616, 
  -9.771934674876045, -9.07884145329925, -8.385802183275748, 
  -7.692870794073628, -7.000155077403953, -6.307870349602096, 
  -5.6164461767021985, -4.926737437923815, -4.240436990099817, 
  -3.560863821319821, -2.894396070453098, -2.2528068854448176, 
  -1.6561421973070294, -1.1334921100956385, -0.7156774135618106, 
  -0.4181946392567549, -0.22974039209135846, -0.12107876978221087, 
  -0.06225768413432771, -0.03158205323385195, -0.01590749070075667, 
  -0.00798327045466981, -0.003999068542708832, -0.002001399162701251, 
  -0.0010011666281346393, -0.0005007001789850381, -0.0002503793186388755, 
  -0.00012519696822161727, -0.00006260031153831576, -0.00003130061265135342, 
  0.}, {-14.632782906214125, -13.939636140010128, -13.246489788161654, 
  -12.553344265022956, -11.860200399298716, -11.167059848383033, 
  -10.473925927003025, -9.780805264368594, -9.0877111179223, 
  -8.394669998640563, -7.701734912844001, -7.009011810665392, 
  -6.316712342500298, -5.625258810973174, -4.935491839216197, 
  -4.249076830092008, -3.5692819058945373, -2.9023982242702417, 
  -2.2600741473667183, -1.6622433584028784, -1.1380415233861734, 
  -0.7186128700663471, -0.4198562367535529, -0.23060614190680617, 
  -0.12151412090772541, -0.06247454452549223, -0.031690035997885634, 
  -0.01596133463326603, -0.008010150745110639, -0.004012497642993277, 
  -0.00200811087179227, -0.0010045217623404058, -0.0005023775647371207, 
  -0.0002512179660186727, -0.00012561628051758323, -0.00006280996483537013, 
  -0.00003140543858669533, 0.}, {-14.641871740951187, -13.948724967224988, 
  -13.255578600332143, -12.562433047104825, -11.869289121203835, 
  -11.17614844993661, -10.483014287861343, -9.789893143867706, 
  -9.09679803482823, -8.403754990860913, -7.71081605769526, -7.018085268778365
  , -6.325770459069241, -5.634286371649877, -4.944458792650164, 
  -4.257924553796584, -3.5778988500059636, -2.9105823787427405, 
  -2.2674939769124127, -1.6684520022444185, -1.1426438706079607, 
  -0.7215561038843896, -0.42150441491045565, -0.2314562399720794, 
  -0.121938333323066, -0.06268481895954592, -0.03179444367247682, 
  -0.0160133166843605, -0.008036081013693498, -0.0040254468985965915, 
  -0.0020145814420865654, -0.0010077560220263697, -0.0005039944368224963, 
  -0.00025202633744750183, -0.00012602045005662423, -0.00006301204555828493, 
  -0.000031506477936364224, 0.}, {-14.651181971967992, -13.958035190421741, 
  -13.264888807888823, -12.571743223381487, -11.878599234920971, 
  -11.185458438536726, -10.492324026235549, -9.79920238182263, 
  -9.1061062720747, -8.41306122721079, -7.720118294332153, -7.027379514301484
  , -6.335048755544956, -5.643532902204351, -4.9536423157128535, 
  -4.2669841250450125, -3.5867185044781427, -2.9189521430332785, 
  -2.2750694786706163, -1.6747703093932138, -1.1473001068375464, 
  -0.7245071625673571, -0.4231389870812785, -0.23229058152010262, 
  -0.1223513798539686, -0.06288850764575894, -0.031895281180382165, 
  -0.016063440727117056, -0.00806106357838766, -0.004037917567600664, 
  -0.0020208115278783864, -0.001010869740712932, -0.0005055509636026983, 
  -0.0002528045175075268, -0.00012640951923048656, -0.00006320657492827752, 
  -0.000031603741316499616, 0.}, {-14.660717807817024, -13.967571018149934, 
  -13.274424619375374, -12.58127900238488, -11.888134948958577, 
  -11.194994022644867, -10.501859350493193, -9.808737186412996, 
  -9.115640037465363, -8.422592914741339, -7.729645828298522, 
  -7.036898749754948, -6.344551428364539, -5.6530025867668, -4.963046567378524
  , -4.276259650488984, -3.595744864444499, -2.9275112697519585, 
  -2.2828038890145335, -1.6812005549983828, -1.152011221617879, 
  -0.7274660875167062, -0.4247597574711363, -0.23310905957883535, 
  -0.12275323406230483, -0.0630856118174613, -0.03199255414267092, 
  -0.01611171103259735, -0.00808510096859261, -0.004049911016936189, 
  -0.0020268018386719734, -0.0010138632797237171, -0.0005070473273897317, 
  -0.00025355259776821084, -0.0001267835339272041, -0.00006339357591502119, 
  -0.00003169724021928174, 0.}, {-14.670483603586572, -13.977336805495051, 
  -13.284190389871663, -12.591044739183651, -11.897900618362856, 
  -11.204759557262342, -10.511624615545774, -9.818501912370651, 
  -9.125403685372605, -8.432354407105347, -7.73940301180533, 
  -7.046647324455582, -6.354282821014942, -5.6626997570009285, 
  -4.97267585503301, -4.285755386607598, -3.6049820764613028, 
  -2.936263662072236, -2.290700582613079, -1.687745113139216, 
  -1.1567782399574669, -0.7304329134791971, -0.42636652102095607, 
  -0.23391156507940306, -0.12314387030402797, -0.06327613374195487, 
  -0.032086268874545486, -0.016158132264770354, -0.008108195921751615, 
  -0.0040614287204651855, -0.00203255313816654, -0.0010167370276606788, 
  -0.000508483724180482, -0.00025427067665316673, -0.0001271425434648094, 
  -0.00006357307320433556, -0.00003178698699350203, 0.}, {-14.680483868150954
  , -13.987337061328743, -13.294190628244005, -12.601044942633434, 
  -11.907900751968086, -11.21475955118071, -10.521624330099414, 
  -9.82850106823079, -9.135401723989563, -8.442350211811092, 
  -7.7493943509881325, -7.056629741781482, -6.364247431311724, 
  -5.6726288994098955, -4.982534641830149, -4.295475747149167, 
  -3.614434446060114, -2.945213381287741, -2.298763079352932, 
  -1.6944064614389003, -1.1616022233758785, -0.733407668017087, 
  -0.42795906329486144, -0.23469798696833713, -0.1235232637874498, 
  -0.06346007673012737, -0.032176432380998266, -0.016202709475372862, 
  -0.008130351379946903, -0.004072472257055946, -0.002038066243235135, 
  -0.0010194913998817035, -0.000509860363391666, -0.00025495885930578127, 
  -0.00012748660052448887, -0.00006374509316387822, -0.0000318729948302407, 0.
  }, {-14.690723271883085, -13.997576456021394, -13.304430004857734, 
  -12.611284283089464, -11.918140020109293, -11.224998674694586, 
  -10.531863164367875, -9.838739324045429, -9.145638823044555, 
  -8.452584997938636, -7.759624513627055, -7.066850666899335, 
  -6.374449919140805, -5.682794663105955, -4.992627554513279, 
  -4.305425311040824, -3.6241064457726835, -2.954364654843841, 
  -2.306995051703448, -1.7011871859695153, -1.1664842709971148, 
  -0.7363903709518995, -0.42953716037105155, -0.23546821232401605, 
  -0.12389139063178216, -0.06363744514574485, -0.032263052352299024, 
  -0.016245448098714286, -0.008151570486474581, -0.004083043308654227, 
  -0.002043342022905503, -0.0010221268379740473, -0.0005111774675932127, 
  -0.0002556172574563915, -0.00012781576108240438, -0.00006390966380961342, 
  -0.000031955277744436345, 0.}, {-14.701206654865485, -14.008059829653153, 
  -13.314913359788248, -12.621767600617638, -11.928623262833378, 
  -11.235481767812868, -10.54234595828405, -9.849221519595378, 
  -9.156119822013984, -8.463063604354614, -7.770098337365388, 
  -7.077314934990519, -6.384895114699333, -5.693201868079906, 
  -5.002959391737948, -4.31560883080218, -3.6340027236648766, 
  -2.9637218848809175, -2.3154003325593697, -1.70808998647016, 
  -1.1714255206923612, -0.7393810337804744, -0.4311005787368791, 
  -0.23622212647738372, -0.12424822792586673, -0.06380824441438979, 
  -0.03234613715931113, -0.016286353946418423, -0.008171856582402236, 
  -0.004093143658344349, -0.0020483813973341744, -0.0010246438092307204, 
  -0.0005124352722426302, -0.00025624598928712536, -0.00012813008434295773, 
  -0.00006406681477250262, -0.000032033850558453974, 0.}, {-14.71193903563916
  , -14.01879220076281, -13.325645711569907, -12.632499913743452, 
  -11.93935549864811, -11.24621384900787, -10.553077730249317, 
  -9.85995267314008, -9.166849738873161, -8.47379104846501, -7.780820838466211
  , -7.088027560015395, -6.395588027275098, -5.70385551400976, 
  -5.0135351329352895, -4.326031241502626, -3.6441281124194975, 
  -2.973289657329678, -2.3239829235995044, -1.7151176819026892, 
  -1.1764271502737045, -0.7423796590618665, -0.43264907518881923, 
  -0.23695961313701894, -0.12459375378702514, -0.06397248103201547, 
  -0.03242569584862385, -0.016325433202110357, -0.008191213203108994, 
  -0.004102775188411612, -0.0020531853367840164, -0.0010270428061223713, 
  -0.0005136340254176951, -0.0002568451792988486, -0.0001284296326723872, 
  -0.0000642165772641954, -0.00003210872888554188, 0.}, {-14.722925620533488, 
  -14.029778775677693, -13.336632266525939, -12.643486428781939, 
  -11.95034193385213, -11.257200124545435, -10.564063686463914, 
  -9.870937990748487, -9.177833779428164, -8.48477253554899, 
  -7.791797221150183, -7.098993744058947, -6.406533854607604, 
  -5.714760789651799, -5.024359947759256, -4.336697670305534, 
  -3.6544876390116574, -2.983072751602634, -2.3327470042030867, 
  -1.7222732163689993, -1.181490378740376, -0.74538623977379, 
  -0.43418239673809406, -0.23768055451860837, -0.12492794741994255, 
  -0.06413016257309408, -0.032501738137506286, -0.016362692416041786, 
  -0.00820964407481171, -0.004111939878393322, -0.0020577548605979117, 
  -0.0010293243457724565, -0.000514773987550681, -0.000257414958175666, 
  -0.00012871447153025374, -0.00006435898404360863, -0.000032179929112400363, 
  0.}, {-14.734171813624336, -14.041024958471795, -13.34787842872659, 
  -12.654732549795845, -11.961587972493179, -11.268445998443305, 
  -10.575309230885551, -9.882182876258172, -9.189077347275978, 
  -8.496013468721062, -7.803032887561732, -7.110218887304965, 
  -6.417737992878053, -5.725923082861227, -5.035439206164952, 
  -4.347613446646771, -3.6650865350244426, -2.993076150930012, 
  -2.34169694096952, -1.7295596654214738, -1.1866164675790885, 
  -0.748400758637171, -0.4357002805227335, -0.23838483147886452, 
  -0.12525078917551807, -0.0642812976983247, -0.032574274408667565, 
  -0.016398138499662006, -0.008227153111071433, -0.0041206398031341995, 
  -0.002062091036172025, -0.0010314889694311392, -0.0005158554311613566, 
  -0.00025795546265241733, -0.00012898466940236992, -0.00006449406938383839, 
  -0.00003224746838297162, 0.}, {-14.745683227372192, -14.052536361603913, 
  -13.35938981062727, -12.666243889233812, -11.973099227006363, 
  -11.279957083109498, -10.58681997586806, -9.8936929419145, 
  -9.200586054444681, -8.507519459573333, -7.814533448415418, 
  -7.121708598690591, -6.429206047380013, -5.737347991294227, 
  -5.046778489169907, -4.358784113099481, -3.6759302476572184, 
  -3.003305053393014, -2.3508372978915597, -1.7369802427947947, 
  -1.1918067221200528, -0.751423187407492, -0.4372024537268977, 
  -0.23907232365391043, -0.12556226060958633, -0.06442589616188002, 
  -0.0326433157048289, -0.01643177872012943, -0.00824374440929223, 
  -0.0041288771308329066, -0.002066194977930658, -0.0010335372419479165, 
  -0.0005168786405913017, -0.0002584668353802829, -0.00012924029773439408, 
  -0.0000646218690375174, -0.00003231136458123035, 0.}, {-14.757465693997155, 
  -14.064318817292643, -13.371172244443576, -12.678026279305431, 
  -11.98488152958926, -11.29173921071756, -10.598601753536897, 
  -9.905474019746658, -9.212365732770536, -8.519296339554698, 
  -7.826304734379322, -7.133468707298035, -6.440943843927602, 
  -5.749041333848265, -5.058383600355168, -4.370215436982117, 
  -3.687024451484007, -3.0137648837124726, -2.3601728472369, 
  -1.7445383075896526, -1.1970624929502351, -0.7544534861315241, 
  -0.43868863350831744, -0.2397429096021535, -0.1258623445414427, 
  -0.06456396881816576, -0.03270887372309695, -0.0164636206947697, 
  -0.008259422247202138, -0.004136654121090432, -0.0020700678462987035, 
  -0.001035469751247315, -0.0005178439117379921, -0.00025894922479216407, 
  -0.00012948143086409178, -0.0000647424202038375, -0.00003237163631419642, 0.
  }, {-14.769525277653273, -14.076378389690731, -13.383231794325646, 
  -12.690085784155631, -11.996940944376378, -11.303798445381156, 
  -10.61066062796401, -9.917532173743053, -9.224422446074463, 
  -8.531350172149459, -7.838352808257932, -7.145505274545962, 
  -6.452957441063694, -5.76100916290312, -5.0702605781687184, 
  -4.3819134227724215, -3.6983750610250326, -3.024461305856659, 
  -2.3697085811985246, -1.7522373719598554, -1.2023851773853886, 
  -0.7574916023681191, -0.44015852693474133, -0.2403964669516253, 
  -0.12615102511206439, -0.06469552762806671, -0.032770960809140895, 
  -0.01649367238547711, -0.008274191079325324, -0.004143973122955124, 
  -0.00207371084667793, -0.0010372871078036527, -0.000518751551788539, 
  -0.00025940278496994874, -0.00012970814595492845, -0.00006485576149512817, 
  -0.00003242830289583565, 0.}, {-14.781868287470976, -14.088721387927514, 
  -13.39557476940063, -12.702428712907182, -12.00928378048173, 
  -11.316141096196775, -10.623002908210816, -9.92987371289484, 
  -9.236762503206657, -8.543687265924117, -7.850683978043295, 
  -7.1578246072493075, -6.465253143136869, -5.773257777431417, 
  -5.082415709100043, -4.393884325396287, -3.7099882442008645, 
  -3.0354002365384143, -2.3794497243802772, -1.760081109317557, 
  -1.207776221002368, -0.7605374703717561, -0.4416118309303144, 
  -0.24103287255178416, -0.12642828784196594, -0.06482058566465816, 
  -0.032829589951168234, -0.016521942093063582, -0.008288055533443283, 
  -0.004150836572968391, -0.002077125228421318, -0.0010389899441167602, 
  -0.0005196018789550842, -0.00025982767551166317, -0.00012992052292866261, 
  -0.00006496193290299047, -0.000032481384329295185, 0.}, {-14.794501291543405
  , -14.101354380095254, -13.408207737759033, -12.715061633647078, 
  -12.021916605985284, -11.32877373123032, -10.635635162315063, 
  -9.942505205183352, -9.249392472035128, -8.556314188518135, 
  -7.863304810910208, -7.170433271623296, -6.4778375143229345, 
  -5.785793737054442, -5.09485554180164, -4.406134664467455, 
  -3.7218704367456206, -3.046587859678837, -2.389401747190831, 
  -1.7680733631415715, -1.2132371192331697, -0.7635910102375438, 
  -0.4430482322328377, -0.24165200262972308, -0.12669411968857622, 
  -0.06493915711835918, -0.03288477477369595, -0.016548438451554792, 
  -0.008301020407044946, -0.0041572469932103446, -0.002080312283810023, 
  -0.0010405789141887721, -0.0005203952222108525, -0.00026022406139717785, 
  -0.0001301186443987153, -0.0000650609757652082, -0.00003253090129169242, 0.}
  , {-14.807431131940259, -14.114284208262998, -13.421137541468596, 
  -12.727991388440449, -12.034846262946942, -11.341703192531241, 
  -10.648564232305253, -9.955433492595061, -9.26231919446179, 
  -8.569237781662299, -7.876222148239086, -7.183338108315297, 
  -6.490717393674597, -5.798623877126867, -5.107586902241167, 
  -4.4186712395619105, -3.7340283576636, -3.058030641922767, 
  -2.3995703802268076, -1.7762181563313295, -1.2187694190220928, 
  -0.7666521270064667, -0.4444674073628952, -0.24225373295074287, 
  -0.1269485091030641, -0.06505125730150806, -0.03293652953111964, 
  -0.01657317042243601, -0.008313090663771507, -0.00416320698934583, 
  -0.002083273347032408, -0.0010420546930025474, -0.0005211319210256381, 
  -0.00026059211285702025, -0.00013030259560420536, -0.00006515293273210366, 
  -0.0000325768751155731, 0.}, {-14.820664940841585, -14.127518004610371, 
  -13.434371312708109, -12.741225109464411, -12.04807988354047, 
  -11.354936612266588, -10.66179725033498, -9.968665707256516, 
  -9.275549802558565, -8.582465177317099, -7.889443121758937, 
  -7.196546248556928, -6.503899911291736, -5.811755324942819, 
  -5.120616909976661, -4.431501146619579, -3.7464690258225373, 
  -3.0697353493001747, -2.409961629734261, -1.7845197013885385, 
  -1.2243747205472912, -0.7697207097297221, -0.4458690226058386, 
  -0.24283793898319864, -0.1271914460865106, -0.06515690265233773, 
  -0.03298486910107562, -0.01659614728884685, -0.00832427142985239, 
  -0.004168719248671891, -0.002086009793164597, -0.0010434179760009444, 
  -0.0005218123251030601, -0.00026093200523907525, -0.00013047246434331775, 
  -0.00006523784773411472, -0.000032619327774033285, 0.}, {-14.834210157893802
  , -14.141063208783622, -13.44791649112347, -12.754770236364157, 
  -12.061624907409659, -11.368481430077335, -10.675341656039544, 
  -9.98220928879153, -9.289091735925716, -8.596003815033407, 
  -7.902975170912698, -7.210065131538712, -6.517392505714559, 
  -5.825195517165569, -5.133952995657179, -4.444631795575829, 
  -3.759199777786573, -3.081709065137587, -2.420581794247236, 
  -1.7929824111888464, -1.2300546790079117, -0.7727966304910515, 
  -0.44725273400766924, -0.24340449606753947, -0.12742292224534196, 
  -0.06525611073833514, -0.033029808977596165, -0.016617378649730067, 
  -0.008334567990534742, -0.004173786538168584, -0.002088523037153121, 
  -0.0010446694785679468, -0.0005224367941182527, -0.0002612439188779486, 
  -0.0001306283409077819, -0.00006531576594792822, -0.0000326582818632876, 0.}
  , {-14.848074548901351, -14.154927586587268, -13.46178084251935, 
  -12.76863453494467, -12.075489100360105, -11.382345411770302, 
  -10.68920521522818, -9.996072003014001, -9.30295276038586, 
  -8.609861460648869, -7.916826061558361, -7.223902523120643, 
  -6.531202942652996, -5.838952218594235, -5.147602919862253, 
  -4.458070929336383, -3.7722282870031916, -3.0939592093348702, 
  -2.4314374825127723, -1.801610910627147, -1.2358110064778585, 
  -0.7758797433860873, -0.4486181873858603, -0.24395327958941476, 
  -0.1276429308459261, -0.06534890025896274, -0.03307136526405968, 
  -0.01663687441393234, -0.008343985786509762, -0.004178411702550602, 
  -0.002090814532801764, -0.0010458099355113153, -0.0005230056974574365, 
  -0.00026152803896244077, -0.00013077031801601697, -0.00006538673376383467, 
  -0.000032693760586014736, 0.}, {-14.862266225979827, -14.169119250137243, 
  -13.475972479012361, -12.782826117323923, -12.089680574512492, 
  -11.396536669471589, -10.703396040037772, -10.010261962082238, 
  -9.31714098813951, -8.624046226445829, -7.931003906131714, 
  -7.238066536004541, -6.545339335178216, -5.853033542393346, 
  -5.161574793406082, -4.471826644221721, -3.7855625844708816, 
  -3.1064935591353615, -2.4425356328237418, -1.810410049120597, 
  -1.2416454738270408, -0.7789698834578587, -0.44996501835617103, 
  -0.2444841651567255, -0.1278514668682453, -0.06543529104772917, 
  -0.033109554665934765, -0.016654644794261767, -0.008352530410335434, 
  -0.004182597662324862, -0.002092885771759958, -0.001046840100547208, 
  -0.0005235194139569252, -0.00026178455540634997, -0.00013089849074871934, 
  -0.0000654507987530828, -0.00003272578773592411, 0.}, {-14.876793669310546, 
  -14.183646679615473, -13.490499880785656, -12.797353463687505, 
  -12.1042078100573, -11.411063683381432, -10.717922610688037, 
  -10.024787646254739, -9.331664899522059, -8.638566592910779, 
  -7.945517185410665, -7.252565651508133, -6.559810165516193, 
  -5.867447971925222, -5.17587709924643, -4.4859074120211595, 
  -3.7992110810284316, -3.11932027153154, -2.4538835338944476, 
  -1.819384914061911, -1.2475599127108066, -0.7820668655876938, 
  -0.45129285237652295, -0.24499702878046134, -0.12804852705854453, 
  -0.06551530407359454, -0.03314439448331718, -0.016670700301501945, 
  -0.008360207602855267, -0.004186347411849972, -0.002094738282515729, 
  -0.0010477607457871033, -0.0005239783316445703, -0.0002620136627168304, 
  -0.00013101295648322846, -0.00006550800963545602, -0.00003275438768021308, 
  0.}, {-14.891665750652432, -14.198518746781776, -13.505371919600833, 
  -12.812225445800589, -12.119079678766832, -11.425935325286396, 
  -10.73279379899401, -10.039657927403308, -9.346533366518141, 
  -8.65343143225118, -7.960374772037014, -7.267408743096723, 
  -6.574624308599191, -5.882204384341031, -5.190518716154129, 
  -4.500322103812705, -3.813182591422727, -3.1324479074645555, 
  -2.465488847429212, -1.8285408453094876, -1.2535562176279758, 
  -0.7851704833409617, -0.45260130480902094, -0.24549174705915452, 
  -0.12823410998087018, -0.06558896144168984, -0.033175902603262204, 
  -0.016685051738385182, -0.008367023249617451, -0.0041896640174020295, 
  -0.002096373629390869, -0.0010485726612274758, -0.0005243828474820861, 
  -0.00026221555986663536, -0.00013111381482855834, -0.00006555841624596058, 
  -0.00003277958534446664, 0.}, {-14.906891758785097, -14.213744740416947, 
  -13.520597884241056, -12.827451352451071, -12.134305469438447, 
  -11.441160884002754, -10.748018893809745, -10.05488209445738, 
  -9.361755678207205, -8.668650033843544, -7.975585955969554, 
  -7.282605101846344, -6.589791057549037, -5.89731207610439, 
  -5.205508944317118, -4.515080015722817, -3.827486360329993, 
  -3.145885457994095, -2.4773596325514737, -1.8378834508101056, 
  -1.259636348047657, -0.7882805077672337, -0.45388998100118433, 
  -0.24596819736675632, -0.1284082160674035, -0.06565628639334688, 
  -0.0332040974919155, -0.01669771019352799, -0.00837298337729456, 
  -0.004192550615244029, -0.00209779341154301, -0.0010492766542401111, 
  -0.0005247333671080354, -0.00026239045016347186, -0.00013120116756098373, 
  -0.0000656020695036232, -0.00003280140619555871, 0.}, {-14.922481427077459, 
  -14.22933439389139, -13.536187508079697, -12.843040917018257, 
  -12.149894915463323, -11.456750092945411, -10.763607628597558, 
  -10.07046988097389, -9.377341568334657, -8.684232131807121, 
  -7.991160472062839, -7.2981644640327055, -6.605320151286516, 
  -5.912780790641862, -5.220857533073364, -4.5301908968206615, 
  -3.8421320905259333, -3.1596423726357576, -2.489504372280597, 
  -1.8474186234474008, -1.2658023306046808, -0.791396686154656, 
  -0.4551584763874514, -0.24642625804372556, -0.12857084766749408, 
  -0.06571730330541879, -0.033228998186441816, -0.01670868703532921, 
  -0.008378094150102188, -0.004195010409704117, -0.0020989992619689364, 
  -0.0010498735490662861, -0.0005250303045833635, -0.0002625385411239062, 
  -0.00013127511856018137, -0.00006563902137851201, -0.00003281987622610762, 
  0.}, {-14.938444963399478, -14.245297915076858, -13.552150998992099, 
  -12.859004347384671, -12.165858224738344, -11.472713160039952, 
  -10.779570211340388, -10.086431495050286, -9.39330124522615, 
  -8.700187934920752, -8.007108529989182, -7.314097041063515, 
  -6.6212218044844375, -5.928620748337872, -5.236574710990266, 
  -4.545664979364658, -3.8571299734235054, -3.1737285900865126, 
  -2.5019320022658533, -1.8571525593108151, -1.272056261363142, 
  -0.7945187407385702, -0.4564063766120285, -0.24686580859110357, 
  -0.12872200909531198, -0.06577203768888792, -0.03325062428675265, 
  -0.01671799390583296, -0.008382361866223246, -0.004197046671257371, 
  -0.0020999928465150366, -0.0010503641863141508, -0.0005252740821375934, 
  -0.0002626600443441591, -0.00013133577374492656, -0.00006566932485997896, 
  -0.00003283502193859867, 0.}, {-14.954793082621023, -14.261646018845338, 
  -13.568499071854484, -12.875352358435002, -12.182206112165119, 
  -11.489060800221827, -10.795917357041311, -10.102777651824685, 
  -9.409645424289044, -8.716528159126927, -8.02344084674792, 
  -7.330413551998193, -6.637506740108406, -5.944842679118086, 
  -5.25267121853461, -4.561513011645657, -3.872490722223604, 
  -3.1881545715855655, -2.514651942012475, -1.8670917773258273, 
  -1.27840030814708, -0.7976463673646392, -0.45763325767409935, 
  -0.24728672986731662, -0.1288617066760209, -0.06582051618674518, 
  -0.0332689959470407, -0.016725642714560614, -0.008385792954232271, 
  -0.004198662734616835, -0.002100775862891115, -0.0010507494224581977, 
  -0.0005254651299165703, -0.00026275517537478613, -0.0001313832410096775, 
  -0.00006569303392534601, -0.00003284687032895139, 0.}, {-14.97153704197219, 
  -14.278389962429372, -13.585242983904287, -12.892096207416474, 
  -12.19894983501045, -11.505804270796979, -10.812660323084492, 
  -10.11951960883748, -9.426385363375326, -8.733264062897332, 
  -8.04016868203622, -7.347125258929254, -6.654186224819541, 
  -5.961457857895501, -5.269158343607351, -4.577746293701225, 
  -3.888225607954228, -3.2029313371884114, -2.5276741288636693, 
  -1.8772431406423997, -1.2848367129368994, -0.8007792341070369, 
  -0.4588386860964344, -0.24768890428744145, -0.12898994879038986, 
  -0.06586276657114301, -0.033284133867119606, -0.016731645632313094, 
  -0.008388393969528828, -0.004199861996832014, -0.002101350039690359, 
  -0.0010510301293408264, -0.0005256038857317568, -0.00026282415359469067, 
  -0.00013141763016271437, -0.00006571020350792524, -0.00003285544887141919, 
  0.}, {-14.988688679573853, -14.295541583952625, -13.602394573270752, 
  -12.909247732469487, -12.21610123143705, -11.52295540997272, 
  -10.829810947766394, -10.13666920456322, -9.4435329013148, 
  -8.750407485768687, -8.057303876790238, -7.36424400553417, 
  -6.671272107547978, -5.978478143188062, -5.2860479602520805, 
  -4.594376716210195, -3.9043464987083203, -3.218070505266711, 
  -2.5410090550356212, -1.8876138797578683, -1.291367794329543, 
  -0.8039169798425715, -0.4600222191183424, -0.2480722160246541, 
  -0.129106745917755, -0.06589881773980358, -0.033296059283570885, 
  -0.016736015084943538, -0.008390171590773023, -0.004200647915394558, 
  -0.00210171713541546, -0.0010512071936793332, -0.0005256907948114118, 
  -0.000262867202085802, -0.00013143905286150165, -0.00006572088946648216, 
  -0.00003286078550226767, 0.}, {-15.006260456486977, -14.313113344479206, 
  -13.619966301024268, -12.926819394676993, -12.233672762552995, 
  -11.540526678907367, -10.847381692345751, -10.154238900461229, 
  -9.461100499967056, -8.767970890397397, -8.074858895245141, 
  -7.381782259146197, -6.68877686158561, -5.995916019256264, 
  -5.303352570885677, -4.611416802916182, -3.920865902430224, 
  -3.2335843355865794, -2.5546678080405414, -1.89821161762985, 
  -1.2979959500598164, -0.807059212781928, -0.46118340491394055, 
  -0.2484365512135435, -0.12921211067725233, -0.06592869971168866, 
  -0.03330479396070869, -0.01673876374710723, -0.008391132616330715, 
  -0.0042010240063549194, -0.0021018789375083394, -0.0010512815165743302, 
  -0.0005257263095542088, -0.00026288454750986244, -0.00013144762255271408, 
  -0.00006572514855270058, -0.00003286290860500725, 0.}, {-15.024265502674767
  , -14.33111837397582, -13.637971297138554, -12.944824324026728, 
  -12.251677558374043, -11.558531207672713, -10.865385687006368, 
  -10.172241826939098, -9.479101290186302, -8.785967408527071, 
  -8.09284687090804, -7.399753156738241, -6.706713630592128, 
  -6.013784642154795, -5.321085352445228, -4.628879756974463, 
  -3.937797013646334, -3.249485776363809, -2.5686621148764677, 
  -1.9090443969703368, -1.3047236595724203, -0.8102055089596218, 
  -0.4623217828366082, -0.24878179815498241, -0.12930605786723853, 
  -0.06595244362192292, -0.03331036018135871, -0.016739904535986703, 
  -0.008391283960726977, -0.004200993842446572, -0.0021018372613888247, 
  -0.0010512540130221508, -0.0005257108892824065, -0.00026287641998443617, 
  -0.00013144345440948635, -0.00006572303838175603, -0.000032861846994182496, 
  0.}, {-15.042717667324224, -14.349570521633343, -13.65642341081224, 
  -12.963276369732826, -12.270129468145342, -11.57698284557591, 
  -10.883836781179347, -10.190691833675585, -9.497549122145614, 
  -8.804410891315502, -8.111281656890439, -7.418170555266321, 
  -6.725096278960939, -6.032097890144775, -5.339260206897797, 
  -4.646779511669047, -3.9551537645881276, -3.2657885157474014, 
  -2.5830043904388496, -1.9201207099290594, -1.3115534866836998, 
  -0.8133554106846204, -0.4634368836904716, -0.24910784752220932, 
  -0.1293886045028188, -0.0659700817159658, -0.03331278073746012, 
  -0.016739450604998294, -0.008390632651107855, -0.004200561051221696, 
  -0.002101593949498392, -0.0010511256114305743, -0.0005256449999992372, 
  -0.00026284305296147116, -0.00013142666527010604, -0.00006571461740111289, 
  -0.000032857629900604774, 0.}, {-15.061631574034415, -14.368484411055109, 
  -13.675337265657173, -12.982190155424181, -12.289043115529866, 
  -11.595896216348077, -10.902749598732031, -10.209603544810234, 
  -9.516458620527931, -8.823315964528392, -8.130177881107455, 
  -7.437049086879929, -6.743939447052203, -6.050870418973855, 
  -5.357891816620354, -4.665130786007524, -3.972950881216544, 
  -3.2825070382439034, -2.5977077904866896, -1.9314495305397783, 
  -1.3184880822206952, -0.816508424954033, -0.4645282300296842, 
  -0.2494145925677694, -0.12945976985141347, -0.06598164734303717, 
  -0.033312078920494155, -0.0167374153374808, -0.00838918582371436, 
  -0.0041997293131968184, -0.0021011508703490814, -0.0010508972531388743, 
  -0.00052552911414818, -0.00026278468310597197, -0.00013139737357837196, 
  -0.00006569994486009844, -0.00003285028695591867, 0.}, {-15.081022681449044
  , -14.387875500889475, -13.694728320331029, -13.001581139777084, 
  -12.308433959241139, -11.615286778777193, -10.922139598601248, 
  -10.228992419577303, -9.535845245161356, -8.842698089177409, 
  -8.149551006921424, -7.456404219576834, -6.763258611870581, 
  -6.070117722601716, -5.376995705227402, -4.683949145771535, 
  -3.99120394472705, -3.29965668666575, -2.6127862700993925, 
  -1.9430403499263693, -1.3255301867746485, -0.8196640218327502, 
  -0.4655953364862128, -0.24970192933095686, -0.12951957546628778, 
  -0.06598717494879484, -0.03330827851174302, -0.016733812340366885, 
  -0.008386950720368182, -0.00419850236000974, -0.0021005099175828335, 
  -0.001050569891940746, -0.0005253637103708991, -0.00026270155017600393, 
  -0.00013135569932195374, -0.00006567908078025434, -0.00003283984817750155, 
  0.}, {-15.100907349992564, -14.407760151565952, -13.714612935273436, 
  -13.021465683251407, -12.32831835977951, -11.635170893444547, 
  -10.942023141530091, -10.248874819043246, -9.555725357758007, 
  -8.862573628261808, -8.169417399889095, -7.47625232396158, 
  -6.783070153846875, -6.089856200030161, -5.396588304505565, 
  -4.703251070682389, -4.009929459196488, -3.3172537302689773, 
  -2.6282546477529474, -1.9549032149772918, -1.3326826334550574, 
  -0.8228216328023753, -0.46663771012673627, -0.24996975684536396, 
  -0.12956804521797316, -0.06598670006726265, -0.03330140377238788, 
  -0.016728655437845824, -0.008383934684969247, -0.0041968839725877935, 
  -0.0020996730090336777, -0.0010501444936122245, -0.0005251492732723999, 
  -0.0002625938969028081, -0.00013130176397441537, -0.00006565208592502166, 
  -0.00003282634395414026, 0.}, {-15.121302915464222, -14.428155698889267, 
  -13.735008446300073, -13.041861121684729, -12.348713653026367, 
  -11.655565896319114, -10.96241756366266, -10.26926807970213, 
  -9.576116295510824, -8.882959920368021, -8.189794401366823, 
  -7.496610746862041, -6.80339143047796, -6.110103228992177, 
  -5.416687028209495, -4.7230540284364935, -4.029144926128048, 
  -3.33531543984131, -2.6441286760796645, -1.9670487705699675, 
  -1.3399483506788719, -0.8259806490833237, -0.46765485083919145, 
  -0.2502179773461573, -0.12960520532352374, -0.06598025931201987, 
  -0.03329147943344312, -0.016721958665012665, -0.008380145160009872, 
  -0.0041948779793291174, -0.002098642085801792, -0.0010496220354420417, 
  -0.0005248862931832943, -0.00026246196887402514, -0.00013123569043468474, 
  -0.00006561902177020322, -0.00003280980503004244, 0.}, {-15.142227770355584
  , -14.449080535356886, -13.755933245920216, -13.062785847609941, 
  -12.369638231561815, -11.676490180075424, -10.983341257862254, 
  -10.290190594794534, -9.597036452413864, -8.903875360992739, 
  -8.21070040983928, -7.517497892669565, -6.824240857690483, -6.13087724736543
  , -5.437310353584586, -4.743376556476407, -4.048868926761942, 
  -3.353860170613385, -2.660425120189919, -1.979488305872813, 
  -1.3473303649714052, -0.8291404199345235, -0.4686462517494064, 
  -0.2504464964766752, -0.12963108437353968, -0.06596789036664731, 
  -0.033278530685546856, -0.016713736261513054, -0.008375589683101361, 
  -0.00419248825429518, -0.0020974191113310977, -0.0010490035057680882, 
  -0.0005245752659280646, -0.00026230601441558637, -0.00013115760296941031, 
  -0.00006557995047509208, -0.00003279026249129037, 0.}, {-15.163701453887397
  , -14.470554200195899, -13.777406873373634, -13.084259400292172, 
  -12.391111634701705, -11.697963284130749, -11.004813763748922, 
  -10.311661904345787, -9.618505369301927, -8.925339492585337, 
  -8.232154970967516, -7.538933313398529, -6.845637999924167, 
  -6.1521978433059985, -5.458477911612345, -4.764238352493616, 
  -4.069121213149774, -3.3729074539967714, -2.677161844047005, 
  -1.992233805176804, -1.3548318038105056, -0.8323002509357131, 
  -0.46961139966814736, -0.2506552234939312, -0.12964571335690644, 
  -0.06594963197444646, -0.03326258316859619, -0.01670400266518144, 
  -0.008370275883520415, -0.0041897187154183715, -0.002096006070497177, 
  -0.0010482899035157607, -0.0005242166925926576, -0.0002621262844767135, 
  -0.00013106762715487326, -0.00006553493485304479, -0.00003276774775129564, 
  0.}, {-15.185744751914806, -14.492597479268243, -13.799450114535839, 
  -13.106302565634094, -12.413154648403014, -11.720005994550664, 
  -11.026855867605367, -10.333702795072568, -9.640543833758548, 
  -8.947373104458674, -8.254178877505437, -7.560937808614344, 
  -6.867603670083715, -6.1740858552513265, -5.480210587127373, 
  -4.785660374812347, -4.089922809143887, -3.3924780993063797, 
  -2.69435790663784, -2.0052980037913963, -1.3624558983956578, 
  -0.8354594022579231, -0.47054977556879296, -0.25084407147261384, 
  -0.12964912568319037, -0.06592552392742833, -0.03324366296124945, 
  -0.016692772505679142, -0.008364211478770126, -0.0041865733227217875, 
  -0.002094404968702298, -0.001047482237743195, -0.0005238110792965223, 
  -0.00026192303251458554, -0.00013096588981889972, -0.00006548403834294293, 
  -0.00003274229253536557, 0.}, {-15.208379808030758, -14.515232516174107, 
  -13.822085113021524, -13.128937487279387, -12.435789416367408, 
  -11.74264045515278, -11.04948971348102, -10.356335411487686, 
  -9.663173991222179, -8.969998343898071, -8.276794280414437, 
  -7.583533536559658, -6.890160040689069, -6.196563483122125, 
  -5.502530630135709, -4.807664953984436, -4.1112961226338545, 
  -3.4125943068063203, -2.712033668734913, -2.0186944496141184, 
  -1.370205986470246, -0.8386170869283676, -0.47146085509574825, 
  -0.2510129575071409, -0.12964135720265363, -0.06589560705458875, 
  -0.033221796570289876, -0.016680060598131492, -0.00835740427116186, 
  -0.004183056076552101, -0.002092617830978545, -0.0010465815271886092, 
  -0.0005233589369653132, -0.0002616965143815592, -0.0001308525189849937, 
  -0.00006542732498098773, -0.00003271392886760114, 0.}, {-15.231630247411372
  , -14.538482936097335, -13.845335494029964, -13.152187790458205, 
  -12.459039563886778, -11.765890291352457, -11.072738927038115, 
  -10.379583379746828, -9.686419468834327, -8.993238840012268, 
  -8.300024812720027, -7.606744138022577, -6.913330767767808, 
  -6.219654412266976, -5.525461779878287, -4.8302759171393275, 
  -4.133265070576399, -3.433279793633195, -2.730210911914487, 
  -2.0324375710696203, -1.3780855150745424, -0.8417724690965575, 
  -0.47234410910356045, -0.2511618029113599, -0.129622446223833, 
  -0.06585992320947354, -0.03319701091986509, -0.016665881936771845, 
  -0.008349862144414784, -0.004179171015829578, -0.0020906467011005143, 
  -0.0010455887998235347, -0.0005228607811064816, -0.0002614469882116125, 
  -0.00013072764381547063, -0.00006536485937193946, -0.00003268268905668474, 
  0.}, {-15.255521315201406, -14.56237398419088, -13.869226502730516, 
  -13.176078720372699, -12.48293033622887, -11.789780748548605, 
  -11.096628753937814, -10.403471946035404, -9.710305513827791, 
  -9.017119842124437, -8.323895727908528, -7.630594874744964, 
  -6.937141129287727, -6.243383951947648, -5.549029403437501, 
  -4.853518726887499, -4.155855218619405, -3.4545599344059683, 
  -2.7489129715181604, -2.0465427522148043, -1.3860980432557775, 
  -0.8449246623091641, -0.4731990042265846, -0.2512905334154429, 
  -0.12959243352865313, -0.0658185152570507, -0.033169333340603326, 
  -0.016650251688586176, -0.00834159306027956, -0.004174922216311334, 
  -0.0020884936407040136, -0.0010445050924101607, -0.0005223171315875318, 
  -0.0002611747143105634, -0.0001305913945558124, -0.0000652967066620224, 
  -0.00003264860568122375, 0.}, {-15.28008003154125, -14.586932680603827, 
  -13.893785159289644, -13.200637297224096, -12.507488753664434, 
  -11.814338847151005, -11.1211862148679, -10.42802813159691, 
  -9.734859148556408, -9.041668374804745, -8.348434054965274, 
  -7.655112784472247, -6.961618180231002, -6.267779190466493, 
  -5.573260650988245, -4.877420636878974, -4.17909393742422, 
  -3.4764619186359855, -2.768164885565241, -2.061026415924302, 
  -1.394247244703949, -0.848072727801717, -0.4740250034789124, 
  -0.25139907935955236, -0.12955136238503634, -0.0657714270598932, 
  -0.033138791558618756, -0.016633185186974018, -0.008332605055179179, 
  -0.0041703137888702, -0.0020861607284175586, -0.0010433314500635684, 
  -0.0005217285124169454, -0.0002608799550451788, -0.00013044390248035466, 
  -0.00006522293251083037, -0.0000326117115769816, 0.}, {-15.305335365700182, 
  -14.612187994614647, -13.919040433004211, -13.225892490346036, 
  -12.532743785600653, -11.83959355671391, -11.14644027967669, 
  -10.453280906867548, -9.760109344631061, -9.06691341200913, 
  -8.373668772519036, -7.6803268551094375, -6.986790926774635, 
  -6.292869169400578, -5.5981846301580385, -4.902010866481829, 
  -4.20301057815376, -3.49901492741511, -2.7879935619636806, 
  -2.075906116209167, -1.4025369103020062, -0.8512156728159622, 
  -0.4748215668841119, -0.2514873758838392, -0.12949927855697957, 
  -0.06571870346369522, -0.03310541368440914, -0.016614697925414736, 
  -0.008322906236876983, -0.004165349877789223, -0.002083650058998551, 
  -0.0010420689258183022, -0.0005210954515261041, -0.00026056297473450366, 
  -0.0001302852998373083, -0.00006514360306467587, -0.00003257203982222135, 0.
  }, {-15.331318432217511, -14.638171040772354, -13.945023438442638, 
  -13.251875414345767, -12.55872654672242, -11.865575992077494, 
  -11.17242206351486, -10.479261387618708, -9.786087219063534, 
  -9.092886073225925, -8.399631004994268, -7.706268220884934, 
  -7.012690522478701, -6.318685079844041, -5.623832602397715, 
  -4.927320797482447, -4.227636670031016, -3.5222503322980976, 
  -2.80842796679726, -2.0912006408794337, -1.4109709505575796, 
  -0.8543524489522927, -0.4755881521342144, -0.2515553631143424, 
  -0.12943623031207782, -0.065660390282125, -0.0330692282016528, 
  -0.016594805551151604, -0.0083125047811657, -0.0041600346590722394, 
  -0.002080963742481371, -0.0010407185802005017, -0.0005204184805553242, 
  -0.00026022403954319075, -0.00013011571979455782, -0.0000650587849287177, 
  -0.0000325296237254919, 0.}, {-15.358062712480873, -14.664915300474815, 
  -13.971767657023259, -13.278619550682539, -12.58547051857083, 
  -11.892319634946507, -11.19916504841441, -10.506003056536644, 
  -9.81282625584754, -9.11961984505963, -8.42635424420046, -7.732970383951415
  , -7.039350489911696, -6.345260484087907, -5.650238204791841, 
  -4.953384196236976, -4.253006143400335, -3.5462019198244583, 
  -2.8294993369418773, -2.1069301259665356, -1.4195533978912804, 
  -0.8574819505673164, -0.47632421527720875, -0.2516029863443645, 
  -0.12936226842647225, -0.06559653428104097, -0.03303026395591659, 
  -0.016573523858891902, -0.008301408928583328, -0.004154372338771576, 
  -0.0020781039033343856, -0.0010392814808037052, -0.0005196981346412252, 
  -0.00025986341737471795, -0.00012993529638756965, -0.00006496854514230858, 
  -0.00003248449681119364, 0.}, {-15.385604305811386, -14.692456873053917, 
  -13.999309188099486, -13.306160998752825, -12.61301180062846, 
  -11.919860584975735, -11.226705334374472, -10.53354201430893, 
  -9.840362557046545, -9.147150832321474, -8.453874600428247, 
  -7.760469465493395, -7.066806971782525, -6.372631566806861, 
  -5.677437701378339, -4.980237465343698, -4.279155582364342, 
  -3.5709061457669167, -2.8512414208942105, -2.1231161835235985, 
  -1.428288408757732, -0.8606030132272531, -0.47702921143215987, 
  -0.251630196210895, -0.12927744618721057, -0.06552718316207523, 
  -0.032988550143275605, -0.016550868784527408, -0.00828962698115242, 
  -0.004148367151332307, -0.0020750726796249877, -0.0010377587018716593, 
  -0.0005189349522075429, -0.00025948137776627306, -0.00012974416446685666, 
  -0.00006487295115034571, -0.00003243669280703157, 0.}, {-15.413982214906003
  , -14.720834761217915, -14.027687034402197, -13.334538761332734, 
  -12.64138939576189, -11.948237845212672, -11.255081924804315, 
  -10.561917265068146, -9.868735128238777, -9.175518043477116, 
  -8.482231087902608, -7.78880449119184, -7.095099016429486, 
  -6.400837420603275, -5.705470268827511, -5.007919929686766, 
  -4.306124511850204, -3.5964024239770116, -2.873690752427554, 
  -2.139782044713527, -1.4371802655650578, -0.8637144122284413, 
  -0.4777025955309209, -0.2516369488656734, -0.12918181939201115, 
  -0.0654523855456122, -0.03294411629885839, -0.016526856398875703, 
  -0.008277167299149136, -0.0041420233579534385, -0.0020718722221965634, 
  -0.001036151323883692, -0.0005181294747584996, -0.00025907819178585915, 
  -0.00012954245964488713, -0.00006477207077928458, -0.0000323862456310243, 0.
  }, {-15.443238671444204, -14.75009119665816, -14.056943427646463, 
  -13.363795070184796, -12.670645535828548, -11.977493647704545, 
  -11.284337052130697, -10.591171041999877, -9.897986204126555, 
  -9.20476371625865, -8.511465950400325, -7.818017716852918, 
  -7.124268903473295, -6.429920371715479, -5.734378322287403, 
  -5.036474162658439, -4.333955724915867, -3.622733455650511, 
  -2.8968869625850635, -2.1569527204095134, -1.4462333783610586, 
  -0.8668148611967602, -0.4783438230852517, -0.25162320614047884, 
  -0.12907544634642812, -0.06537219095317273, -0.032896992285321884, 
  -0.01650150290144905, -0.008264038297895937, -0.004135345244966686, 
  -0.0020685046938522743, -0.001034460433147095, -0.0005172822466736189, 
  -0.0002586541319296231, -0.00012933031824665837, -0.00006466597221037704, 0.
  , 0.}, {-15.473419508844978, -14.780272012806064, -14.087124201288557, 
  -13.393975758814996, -12.700826054433843, -12.007673826255592, 
  -11.314516550555464, -10.621349180100966, -9.92816162129585, 
  -9.234933690426798, -8.541625034017542, -7.848155001186768, 
  -7.1543625166200275, -6.45992635287606, -5.764207888381168, 
  -5.065946359545684, -4.3626956572857445, -3.6499456060865203, 
  -2.9208731366485026, -2.174655181907029, -1.4554522862433088, 
  -0.8699030107783597, -0.4789523509780036, -0.25158893570625646, 
  -0.12895838785841887, -0.06528664978922426, -0.03284720828126362, 
  -0.016474824614247388, -0.008250248444587646, -0.004128337122234219, 
  -0.0020649722685521068, -0.0010326871213940697, -0.0005163938150059878, 
  -0.000258209472021294, -0.00012910787725782752, -0.00006455472395535213, 0.
  , 0.}, {-15.504574590620344, -14.81142707318665, -14.11827921887951, 
  -13.425130690826373, -12.73198081528484, -12.038828244780904, 
  -11.345670284409712, -10.652501544534319, -9.959311246572366, 
  -9.266077836129583, -8.572758215533765, -7.879266234182569, 
  -7.185429772060157, -6.490905331766343, -5.795009033802491, 
  -5.0963867665273455, -4.392394817565864, -3.67808933709146, 
  -2.945696224193038, -2.1929185648151095, -1.4648416584720139, 
  -0.8729774474344614, -0.47952763827687706, -0.2515341112256902, 
  -0.1288307072303174, -0.06519581332243836, -0.032794794769579874, 
  -0.016446837975584834, -0.008235806255141477, -0.0041210033215632515, 
  -0.002061277130616411, -0.0010308324853832392, -0.0005154647292841852, 
  -0.0002577444871118448, -0.00012887527427606275, -0.00006443839483087556, 0.
  , 0.}, {-15.536758304591864, -14.84361076563507, -14.150462868281647, 
  -13.457314254135605, -12.764164206406909, -12.071011291523229, 
  -11.377852642370906, -10.684682524846643, -9.991489471240543, 
  -9.298250548123898, -8.604919896638641, -7.9114058313462445, 
  -7.217525112730076, -6.522911805333298, -5.826836359775188, 
  -5.127850175548099, -4.423108283408714, -3.7072197061398846, 
  -2.9714075113361997, -2.211774399769344, -1.4744062952181625, 
  -0.8760366923534965, -0.4800691470691162, -0.25145871249886287, 
  -0.12869247024823563, -0.06509973366641532, -0.032739782525777694, 
  -0.016417559533946382, -0.008220720291082123, -0.004113348195140054, 
  -0.0020574214739426094, -0.00102889762650795, -0.0005144955413151025, 
  -0.0002572594533822638, -0.00012863264746106184, -0.00006431705393400849, 0.
  , 0.}, {-15.570030135519199, -14.876882574925167, -14.183734634297172, 
  -13.490585933601622, -12.797435712772428, -12.10428245168184, 
  -11.411123110092046, -10.71795160759823, -10.024755783674577, 
  -9.331511318409017, -8.638169576570608, -7.944633306349889, 
  -7.250708080985043, -6.556005372517793, -5.8597495749257344, 
  -5.160396497618033, -4.454896276180776, -3.737396943565575, 
  -2.9980631685680375, -2.2312568742485372, -1.4841511279231583, 
  -0.879079200494115, -0.480576343315369, -0.25136272560163686, 
  -0.1285437451688955, -0.06499846375989196, -0.03268220260624693, 
  -0.016387005941881184, -0.008204999156454723, -0.0041053761139814154, 
  -0.0020534075012301695, -0.0010268836504079186, -0.0005134868049902099, 
  -0.00025675464804643774, -0.00012838013548656998, -0.00006419077061855468, 
  0., 0.}, {-15.604455331571609, -14.911307749240985, -14.218159765139704, 
  -13.525010977497177, -12.831860582772427, -12.138706973884304, 
  -11.445546936673747, -10.752374042835639, -10.05917543581231, 
  -9.365925402702947, -8.672572518598269, -7.979013937523709, 
  -7.285043985114399, -6.590251400824891, -5.893814161999253, 
  -5.194091429968391, -4.487824829564175, -3.768687124749863, 
  -3.0257248867492956, -2.2514031306381437, -1.4940812192134962, 
  -0.8821033597729032, -0.4810486977207669, -0.2512461430164288, 
  -0.1283846027039275, -0.06489205734646175, -0.03262208633650285, 
  -0.01635519394993132, -0.008188651494770537, -0.004097091466408784, 
  -0.0020492374232164235, -0.0010247916665883346, -0.0005124390760953803, 
  -0.0002562303492548132, -0.00012811787749239742, -0.00006405961447040826, 0.
  , 0.}, {-15.64010568373718, -14.946958079586006, -14.253810051843516, 
  -13.560661176918137, -12.867510607625945, -12.174356649596003, 
  -11.481195914074044, -10.788021623502079, -10.094820222566801, 
  -9.401564599856378, -8.708200529439267, -8.01461954728527, 
  -7.320604678793726, -6.625721805830798, -5.929102157513387, 
  -5.229007236157846, -4.521966571215502, -3.8011629551390365, 
  -3.054460620762231, -2.272253606698679, -1.5042017623229142, 
  -0.8851074904107976, -0.4814856866212103, -0.2511089637550486, 
  -0.12821511600165217, -0.06478056895382295, -0.032559465299402894, 
  -0.01632214040060357, -0.008171685985985064, -0.004088498656536076, 
  -0.0020449134579237777, -0.001022622788042644, -0.000511352912121383, 
  -0.00025568683600172334, -0.00012784601303832512, -0.0000639236552847892, 0.
  , 0.}, {-15.677060441957774, -14.983912815918112, -14.290764744398526, 
  -13.597615781918492, -12.904465037515124, -12.21131072925536, 
  -11.518149293243901, -10.824973601573499, -10.131769397963541, 
  -9.438508167992232, -8.745132875404622, -8.051529418293972, 
  -7.357469477261855, -6.662495967414246, -5.965693068137601, 
  -5.265223662916701, -4.557401641201418, -3.8349046927241255, 
  -3.084345462640397, -2.2938524258062474, -1.5145180799612974, 
  -0.8880898444523184, -0.48188679288264447, -0.2509511934733139, 
  -0.1280353606263815, -0.0646640538725804, -0.03249437132334806, 
  -0.016287862222380572, -0.008154111343510219, -0.0040796021027825445, 
  -0.0020404378299159805, -0.0010203781308819036, -0.0005102288720802671, 
  -0.00025512438803204917, -0.0001275646820555678, -0.0000637829630427016, 0.
  , 0.}, {-15.715407397837375, -15.02225974985793, -14.329111634458663, 
  -13.63596258421876, -12.942811664293659, -12.249657004982438, 
  -11.55649486683609, -10.863317770768, -10.170110757851, -9.476843907218461, 
  -8.783457365116176, -8.089831376178374, -7.395726240070294, 
  -6.700661812559763, -6.003674953645125, -5.3028290235760895, 
  -4.594218777183654, -3.8700012375771418, -3.1154626725189605, 
  -2.316247845906998, -1.5250356225919854, -0.8910486054716618, 
  -0.4822515068110619, -0.250772844577153, -0.12784541453527629, 
  -0.0645425681346215, -0.03242683647047934, -0.016252376423778, 
  -0.008135936311259247, -0.004070406236402674, -0.002035812769565687, 
  -0.0010180588139688143, -0.0005090675163209715, -0.0002545432857493252, 
  -0.000127274024803789, -0.00006363760788816908, 0., 0.}, {
  -15.755244171662152, -15.062096501708925, -14.368948342361957, 
  -13.675799204226122, -12.982648108507021, -12.289493097599278, 
  -11.596330256225782, -10.903151753566986, -10.209941926922827, 
  -9.516669446652426, -8.82327163653548, -8.129623076574681, 
  -7.435472658143309, -6.740317102470941, -6.043145714175363, 
  -5.34192148581963, -4.632516603975096, -3.9065514262853593, 
  -3.1479049017705716, -2.339492778107491, -1.5357599660349597, 
  -0.8939818884796511, -0.48257932707081364, -0.25057393631993735, 
  -0.12764535805279853, -0.0644161684910949, -0.032356893024866995, 
  -0.016215700087447958, -0.008117169660727144, -0.004060915500036361, 
  -0.0020310405123329755, -0.0010156659585585505, -0.0005078694063508258, 
  -0.00025394381012728895, -0.00012697418182467413, -0.00006348766010535948, 
  0., 0.}, {-15.79667975183936, -15.103532059896278, -14.410383856569457, 
  -13.717234630473348, -13.024083358831438, -12.330927996069018, 
  -11.637764450949938, -10.944584540655024, -10.251371898158762, 
  -9.558093783863912, -8.864684696411159, -8.17101354458339, 
  -7.476817793255616, -6.781570972100535, -6.084214629913294, 
  -5.382610611863669, -4.672405175650534, -3.944665579449567, 
  -3.181775655811381, -2.3636453881532824, -1.5466968083504888, 
  -0.8968877400452325, -0.48286976160873724, -0.2503544948908167, 
  -0.1274352738428039, -0.06428491239000733, -0.032284573480713306, 
  -0.01617785036433254, -0.008097820188105575, -0.0040511343462799445, 
  -0.002026123298054939, -0.0010132006879423796, -0.0005066351046579425, 
  -0.0002533262426202093, -0.00012666529389794673, -0.00006333319009770789, 0.
  , 0.}, {-15.839836348620052, -15.146688634689626, -14.45354038738797, 
  -13.760391073341593, -13.067239625796748, -12.374083911218868, 
  -11.680919662430505, -10.987738344643569, -10.294522886549322, 
  -9.601239138601818, -8.90781877400975, -8.214125028509095, 
  -7.519883931792635, -6.8245457839621615, -6.127004215050284, 
  -5.425019212930014, -4.714007832056935, -3.984467364163301, 
  -3.2171910519741362, -2.388769797192621, -1.5578519659314232, 
  -0.899764138644928, -0.4831223285815177, -0.25011455349383666, 
  -0.1272152468783225, -0.06414885795347039, -0.03220991053056528, 
  -0.016138844467866533, -0.008077896711435387, -0.004041067236277077, 
  -0.0020210633702441227, -0.0010106641271013029, -0.0005053651745370577, 
  -0.00025269086507643683, -0.00012634750199782904, -0.00006317426836481927, 
  0., 0.}, {-15.884851642417832, -15.191703906521823, -14.498555615288844, 
  -13.805406213379184, -13.112254590105248, -12.419098524059065, 
  -11.725933572293622, -11.032750848390608, -10.339532577416398, 
  -9.646243201116663, -8.952811569442213, -8.259095248195573, 
  -7.564808833105316, -6.869379376535509, -6.171652466337829, 
  -5.4692855983219655, -4.75746345004259, -4.026096051965288, 
  -3.254281948131586, -2.414936902101116, -1.5692313687367436, 
  -0.9026089952531082, -0.4833365572836201, -0.24985415241765724, 
  -0.12698536440908592, -0.06400806395461882, -0.03213293705355137, 
  -0.01609869966823544, -0.00805740806779382, -0.004030718638332034, 
  -0.002015862975401045, -0.0010080574023611523, -0.0005040601799183739, 
  -0.0002520379596525099, -0.0001260209472508352, -0.00006301096548159172, 0.
  , 0.}, {-15.93188153205008, -15.23873377423016, -14.545585439149193, 
  -13.852435949542894, -13.159284150873019, -12.466127734024315, 
  -11.772962080611267, -11.079777953242752, -10.386556874656234, 
  -9.69326188040538, -8.999819001912488, -8.306080143282543, 
  -7.6117484777859055, -6.916227812591205, -6.218315611559955, 
  -5.515566324428569, -4.802929194735097, -4.06970927734281, 
  -3.2931965399791716, -2.442225340662544, -1.580841054594749, 
  -0.9054201541853996, -0.48351198907307547, -0.2495733390957058, 
  -0.12674571592685124, -0.06386258979422144, -0.03205368610364593, 
  -0.016057433286686795, -0.00803636311051971, -0.004020093026540542, 
  -0.0020105243623353445, -0.0010053816410542655, -0.000502720685199185, 
  -0.0002513678087299273, -0.0001256857708928986, -0.00006284335207778394, 0.
  , 0.}, {-15.98110352256299, -15.28795574288142, -14.594807364076976, 
  -13.901657787023028, -13.208505813455067, -12.515349046799036, 
  -11.822182693726702, -11.1289971668611, -10.43577328856611, 
  -9.742472692039701, -9.04901859754944, -8.355257261045368, 
  -7.6608804555258505, -6.965268767096393, -6.267171497584851, 
  -5.564039583316619, -4.850583910532639, -4.115486437052403, 
  -3.334103557833518, -2.470722633389297, -1.592687162500966, 
  -0.908195394206778, -0.48364817829235546, -0.24927216815663367, 
  -0.12649639312858632, -0.06371249547701566, -0.03197219089797055, 
  -0.01601506268990131, -0.008014770706476378, -0.00400919487944506, 
  -0.002005049781498344, -0.0010026379711898415, -0.0005013472550775036, 
  -0.00025068069483092254, -0.00012534211422872014, -0.00006267149881636134, 
  0., 0.}, {-16.032720940055732, -15.33957313859604, -14.646424716235163, 
  -13.953275052067626, -13.26012290426957, -12.566965789141689, 
  -11.873798739079014, -11.180611818046136, -10.48738515067003, 
  -9.794078972993423, -9.100613704237464, -8.406829971232982, 
  -7.712408179970998, -7.016705742115974, -6.318423805410163, 
  -5.61490941832365, -4.9006323392264735, -4.16363291732899, 
  -3.3771962344691273, -2.5005265422336964, -1.6047759248323736, 
  -0.9109324299150208, -0.48374469318152263, -0.24895070146495438, 
  -0.12623748987757963, -0.06355784158778506, -0.0318884848051378, 
  -0.01597160528442008, -0.007992639733352574, -0.003998028678709386, 
  -0.001999441484327362, -0.0009998275211248724, -0.0004999404543908038, 
  -0.0002499769005384588, -0.00012499011859067272, -0.00006249547637395191, 0.
  , 0.}, {-16.086968228296897, -15.393820405164556, -14.700671939458198, 
  -14.007522188598937, -13.314369867414394, -12.621212405501392, 
  -11.928044661819875, -11.23485635335488, -10.541626910336563, 
  -9.848315178261721, -9.154838788238877, -8.461032762697071, 
  -7.766566185367114, -7.070773363502341, -6.372307346994217, 
  -5.66841102144271, -4.95331042004886, -4.214385404083267, -3.422697279927049
  , -2.531746697595931, -1.6171136583958476, -0.9136289134092269, 
  -0.4838011167808452, -0.24860900815179343, -0.1259691021625396, 
  -0.06339868926720627, -0.03180260133364774, -0.015927078511135315, 
  -0.00796997907700306, -0.003986598907814825, -0.001993701722600885, 
  -0.0009969514192458727, -0.0004985008479543221, -0.00024925670841567004, 
  -0.0001246299252993713, -0.0000623153554203028, 0., 0.}, {-16.14411767849363
  , -15.45096983381676, -14.757821325021153, -14.0646714879826, 
  -13.371518994436322, -12.678361187787225, -11.985192754583025, 
  -11.29200306687065, -10.598770864549259, -9.905453610632895, 
  -9.211966163968478, -8.518137973172948, -7.823626856356002, 
  -7.127744110733658, -6.429094795232598, -5.724817463856654, 
  -5.008892023013471, -4.268018627524151, -3.4708651858800157, 
  -2.564506559874926, -1.6297067542198347, -0.916282436251939, 
  -0.48381704782003204, -0.24824716463567895, -0.1256913280547593, 
  -0.06323510018749326, -0.03171457412033746, -0.015881499839843227, 
  -0.00794679762882574, -0.003974910050777257, -0.001987832747804156, 
  -0.0009940107936518457, -0.0004970290004053635, -0.00024852040092763534, 
  -0.00012426167562391052, -0.00006213120659918038, 0., 0.}, {
  -16.2044880843756, -15.511340218305664, -14.818191666723708, 
  -14.125041744111645, -13.431889079415075, -12.738730930452318, 
  -12.04556181256849, -11.352370755287588, -10.659135812991764, 
  -9.965813075774664, -9.27231464908239, -8.578464444374086, 
  -7.883909083084175, -7.187936972062412, -6.489105339241115, 
  -5.784448351781018, -5.067697607696613, -4.324854033485632, 
  -3.522002309857403, -2.598945801764347, -1.6425616660299256, 
  -0.9188905317321613, -0.4837921015912832, -0.24786525463334422, 
  -0.12540426766341234, -0.063067136527857, -0.0316244369188978, 
  -0.01583488676386025, -0.007923104283181636, -0.003962966590887346, 
  -0.001981836810507629, -0.000991006771846275, -0.0004955254760483873, 
  -0.00024776826036504185, -0.0001238855107439899, -0.00006194310050938144, 0.
  , 0.}, {-16.268456023978707, -15.575308136691188, -14.882159542673856, 
  -14.189009535190198, -13.49585670074706, -12.802698212277662, 
  -12.109528415326523, -11.416335999694835, -10.723098339832482, 
  -10.02977016401988, -9.336260846266015, -8.642388803785217, 
  -7.947789543008817, -7.251728726358746, -6.552715966328918, 
  -5.847681108996905, -5.130105508862994, -4.385271082966906, 
  -3.5764653781747677, -2.6352232246459426, -1.6556848972333773, 
  -0.9214506774351956, -0.4837259108033364, -0.2474633691605395, 
  -0.12510802308905977, -0.06289486094981184, -0.03153222358845916, 
  -0.015787256794707768, -0.007898907934852893, -0.003950773009471318, 
  -0.0019757161597541767, -0.0009879404804325758, -0.0004939908387043202, 
  -0.0002470005687678495, -0.00012350157171203945, -0.00006175110768485613, 0.
  , 0.}, {-16.336470786994937, -15.643322878690059, -14.950174242637793, 
  -14.257024151083398, -13.563871148495307, -12.870712323722096, 
  -12.177541854107684, -11.484348092926833, -10.791107741075308, 
  -10.09777417771815, -9.404254070587589, -8.71036039202034, 
  -8.015717628267357, -7.319568870514602, -6.620376389527004, 
  -5.91496590493649, -5.196566867781106, -4.449722198855422, 
  -3.634679330920484, -2.6735203598231574, -1.6690829864173637, 
  -0.923960298123648, -0.4836181264137705, -0.24704160652286888, 
  -0.12480269837544528, -0.0627183365723498, -0.031437968082254394, 
  -0.015738627456861623, -0.007874217476541545, -0.003938333784672658, 
  -0.0019694730424601624, -0.0009848130448172343, -0.0004924256515617619, 
  -0.0002462176078511772, -0.00012310999941601183, -0.00006155529857716273, 0.
  , 0.}, {-16.40907445969818, -15.715926530601605, -15.022777852965724, 
  -14.329627678243208, -13.636474509315304, -12.943315351848183, 
  -12.250144216788813, -11.556949124489444, -10.863706109486094, 
  -10.170367216163037, -9.476836434426957, -8.78292134775531, 
  -8.08823553062018, -7.391999704417955, -6.692629132680472, 
  -5.986845740326442, -5.267625721245409, -4.518752871918044, 
  -3.6971558715258226, -2.7140459575249367, -1.682762491186182, 
  -0.9264167689324088, -0.4834684184368394, -0.24660007229670022, 
  -0.12448839945965745, -0.06253762694700711, -0.031341704436364, 
  -0.015689016282574856, -0.00784904179640995, -0.003925653390256402, 
  -0.001963109702825604, -0.0009816255889167464, -0.0004908304770314169, 
  -0.00024541965893363403, -0.00012271093454306308, -0.00006135574353714513, 
  0., 0.}, {-16.486929465780428, -15.793781516143966, -15.10063279742808, 
  -14.407482540544638, -13.714329207291229, -13.021169721158476, 
  -12.327997928709344, -11.634801521396412, -10.941555875429364, 
  -10.248211716429303, -9.5546703883141, -8.860734148569419, 
  -8.166005782300791, -7.469683871831154, -6.770137071437619, 
  -6.06398398871888, -5.3439465466264, -4.593029224394054, -3.7645187784168277
  , -2.757041640585306, -1.6967299702195777, -0.9288174188786361, 
  -0.4832764767242051, -0.24613887930021702, -0.12416523412074239, 
  -0.062352796032847047, -0.031243466758551115, -0.0156384408067672, 
  -0.007823389775660002, -0.003912736294436578, -0.0019566283817578707, 
  -0.0009783792348713525, -0.0004892058766034185, -0.00024460700286476283, 
  -0.00012230451754456596, -0.00006115251279672154, 0., 0.}, {
  -16.570857152882255, -15.877709182984562, -15.184560423745983, 
  -14.49141008581622, -13.79825659046644, -13.105096780126022, 
  -12.411924339201853, -11.718726634699976, -11.025478393399107, 
  -10.332129039904096, -9.63857730746116, -8.944620197479727, 
  -8.249849842557113, -7.553442946956719, -6.853722019918172, 
  -6.147202983688197, -5.426352852724159, -4.673376620819438, 
  -3.8375391712599285, -2.8027891061485617, -1.7109919635582351, 
  -0.9311595346859477, -0.48304201171599964, -0.24565814755471088, 
  -0.12383331192684864, -0.06216390817138651, -0.031143289217191603, 
  -0.015586918561989703, -0.007797270286157503, -0.00389958695872346, 
  -0.0019500313163026929, -0.0009750751027644614, -0.00048755241070765797, 
  -0.00024377991995670493, -0.00012189088860056871, -0.000060945676452338676, 
  0., 0.}, {-16.66189320834045, -15.968745218487744, -15.275596419338902, 
  -14.582446001587662, -13.889292346591132, -13.196132216942027, 
  -12.502959137339744, -11.809760155238598, -11.116509357766564, 
  -10.423154888034908, -9.7295929075109, -9.035615238691012, -8.34080351340662
  , -7.6443128502130175, -6.944420146581964, -6.237539435210572, 
  -5.515882599933985, -4.76083510913975, -3.917185826476192, 
  -2.851619414709009, -1.725554970439356, -0.9334403649201429, 
  -0.48276475515976014, -0.24515800423623257, -0.12349274418098753, 
  -0.061971028061482664, -0.031041206030305926, -0.015534467073461225, 
  -0.007770692188093799, -0.003886209836793424, -0.001943320739091486, 
  -0.0009717143103467597, -0.00048587063857722783, -0.00024293868991497795, 
  -0.00012147018758591932, -0.000060735304446649565, 0., 0.}, {
  -16.76136956134634, -16.0682215518731, -15.375072713482954, 
  -14.681922217248145, -13.988768405280629, -13.295607961674154, 
  -12.602434254095527, -11.90923401579522, -11.215980704938474, 
  -10.522621204487793, -9.829049146695002, -9.135051259754691, 
  -8.440198841798587, -7.743625750412725, -7.04356387648976, 
  -6.336326332412796, -5.613870106898926, -4.856741348205785, 
  -4.004698975867144, -2.9039251388788303, -1.7404254260248142, 
  -0.9356571244317626, -0.48244446079485787, -0.24463858361774515, 
  -0.12314364386550261, -0.06177422073421028, -0.030937251454693768, 
  -0.015481103854181538, -0.007743664327693365, -0.0038726093733815227, 
  -0.0019364988777964337, -0.0009682979727680112, -0.0004841611181132036, 
  -0.00024208359177169762, -0.00012104255403750066, -0.00006052146655330017, 
  0., 0.}, {-16.87103958424518, -16.17789155551487, -15.484742678610322, 
  -14.791592105345746, -14.098438139314801, -13.405277387565905, 
  -12.712103063640177, -12.018901592396562, -11.325645814656236, 
  -10.632281376446311, -9.938699427132633, -9.24468169286712, 
  -8.54978932091373, -7.85313526607397, -7.1529070926848295, 
  -6.445318145413327, -5.722071256355732, -4.96285383195914, 
  -4.101702096275926, -2.9601764998905487, -1.7556096744602008, 
  -0.9378069990987754, -0.4820809050001958, -0.24410002700194613, 
  -0.1227861255853229, -0.0615735515277497, -0.030831459775185262, 
  -0.0154268464001167, -0.007716195534960579, -0.003858790003195661, 
  -0.001929567954597106, -0.0009648272023118752, -0.0004824244057547617, 
  -0.00024121490382046689, -0.00012060812712013356, -0.00006030423235927359, 
  0., 0.}, {-16.99327734562953, -16.300129298035266, -15.606980383402579, 
  -14.91382973468074, -14.22067561773135, -13.527514564129891, 
  -12.834339636436335, -12.14113695740619, -11.447878763088745, 
  -10.754509487703906, -10.06091784792204, -9.366880667959933, 
  -8.671949143253766, -7.975215718516373, -7.274824389346099, 
  -6.566890078899996, -5.842862752796106, -5.081552157643838, 
  -4.2103778744511215, -3.0209431761808836, -1.7711139405001224, 
  -0.9398871508605844, -0.4816738874030472, -0.24354248264494555, 
  -0.12242030551009887, -0.06136908606230494, -0.030723865294006603, 
  -0.015371712185468, -0.007688294621471255, -0.0038447561498518175, 
  -0.001922530185660173, -0.0009613031081386354, -0.0004806610563500805, 
  -0.00024033290355182136, -0.00012016704559592209, -0.0000600836712498989, 0.
  , 0.}, {-17.131410613654122, -16.438262547619416, -15.745113596105599, 
  -15.051962873620512, -14.358808609140699, -13.665647260462668, 
  -12.972471742553061, -12.279267882839106, -11.58600732614663, 
  -10.892633321977465, -10.199032208452799, -9.504976016010074, 
  -8.810006203948397, -8.113195135169029, -7.412644075138432, 
  -6.704371075862779, -5.97957513033213, -5.216170024430149, 
  -4.3337583455104935, -3.0869243617504725, -1.786944298086126, 
  -0.9418947230324436, -0.4812232314470753, -0.24296610567100915, 
  -0.12204630131530265, -0.06116089021507994, -0.030614502320267925, 
  -0.01531571865801102, -0.007659970378204143, -0.00383051222483355, 
  -0.0019153877806279856, -0.0009577267960329506, -0.0004788716230298008, 
  -0.0002394378675912302, -0.00011971944779260001, -0.00005985985239274987, 0.
  , 0.}, {-17.290312298146272, -16.5971642141257, -15.90401522663991, 
  -15.210864432209897, -14.517710023836303, -13.824548387354994, 
  -13.131372293775966, -12.438167282471634, -11.74490442159167, 
  -11.051525805015812, -10.357915450512547, -9.663840711143212, 
  -8.96883354285333, -8.271946691663654, -7.571239615331678, 
  -6.862635260045315, -6.1370841992906655, -5.371586621996166, 
  -4.476231521543994, -3.158991132139512, -1.8031066361659174, 
  -0.9438268458872343, -0.48072878491770293, -0.24237105797859707, 
  -0.12166423212238338, -0.06094903009532945, -0.03050340515957761, 
  -0.01525888323452133, -0.0076312315734176584, -0.0038160626264712124, 
  -0.0019081429421204754, -0.0009540993681558476, -0.0004770566570866006, 
  -0.00023853007163732032, -0.00011926547157254373, -0.00005963284472209889, 
  0., 0.}, {-17.47753601861742, -16.784387917097334, -16.091238894612264, 
  -15.398088030182718, -14.704933481806146, -14.011771565303247, 
  -13.318594911618485, -12.625388779852402, -11.93212367704719, 
  -11.238740572608936, -10.545121226293901, -9.851028438636256, 
  -9.15598491254484, -8.459024279817978, -7.758165199791899, 
  -7.049237504209749, -6.32294661858164, -5.55536201920195, -4.64449288732893
  , -3.2382477142312545, -1.8196066214788231, -0.9456806424894542, 
  -0.4801904204231741, -0.24175750813794014, -0.12127421843806546, 
  -0.060733572019508957, -0.03039060810379147, -0.015201223296274512, 
  -0.007602086950568265, -0.003801411738944003, -0.0019007978652457, 
  -0.0009504219228048473, -0.0004752167078532201, -0.00023760979040243405, 
  -0.00011880525430311794, -0.00005940271692492533, 0., 0.}, {
  -17.70573497435236, -17.012586855851556, -16.31943779940481, 
  -15.626286867050943, -14.933132182821861, -14.239969994598457, 
  -13.546792797410733, -12.853585578390836, -12.16031830008583, 
  -11.466930840674317, -10.77330276847794, -10.07919246499525, 
  -9.384113648387068, -8.687081377685109, -7.986074613018679, 
  -7.276832300379057, -6.549818769940601, -5.780155496509236, 
  -4.849512413310709, -3.3261227891467153, -1.836449658081184, 
  -0.9474532347641755, -0.47960803582981004, -0.24112563128042552, 
  -0.12087638209287728, -0.06051458248654162, -0.03027614542089238, 
  -0.015142756184631984, -0.007572545226270732, -0.003786563931305518, 
  -0.0018933547371243718, -0.0009466955541771112, -0.00047335232258615616, 
  -0.0002366772975541872, -0.00011833893282824303, -0.000059169537425147586, 
  0., 0.}, {-17.99862782759876, -17.305479692669174, -16.612330603364626, 
  -15.919179605294199, -15.226024789628182, -14.53286233851565, 
  -13.839684615488622, -13.146476344545851, -12.453206961417386, 
  -11.759815288443068, -11.066178773416944, -10.372051521131317, 
  -9.676938551694533, -8.97983693269089, -8.278687117248671, 
  -7.5691396430646485, -6.841422644974319, -6.069689773288096, 
  -5.111180208242879, -3.42451044127232, -1.8536408433465223, 
  -0.9491417497816907, -0.47898155465013675, -0.24047560898006623, 
  -0.12047084617900072, -0.060292128153225925, -0.030160051345015565, 
  -0.01508349919670404, -0.00754261508830375, -0.003771523556528012, 
  -0.0018858157364235908, -0.0009429213521398314, -0.00047146404635069504, 
  -0.00023573286565802817, -0.00011786664343863032, -0.00005893337437040882, 
  0., 0.}, {-18.409461284411762, -17.716313133639137, -17.023164012648273, 
  -16.33001295120428, -15.636858008787398, -14.943695304158181, 
  -14.250517074037964, -13.55730778866945, -12.864036375731418, 
  -12.170640639300556, -11.476995981970994, -10.782852383189175, 
  -10.087706470544267, -9.390537942413156, -8.68925003317726, 
  -7.97940761002972, -7.251008429446301, -6.477205878265201, 
  -5.471712078942602, -3.5359971580287475, -1.8711849202099555, 
  -0.9507433262365625, -0.4783109263827397, -0.23980762912735595, 
  -0.12005773498752777, -0.06006627580979859, -0.030042360066614385, 
  -0.015023469581099177, -0.007512305193657194, -0.0037562949505718325, 
  -0.0018781830329013343, -0.0009391004020057528, -0.0004695524219106155, 
  -0.00023477676612235223, -0.00011738852184534877, -0.00005869429561775253, 
  0., 0.}, {-19.108136631132655, -18.414988465137203, -17.721839313700457, 
  -17.028688191363788, -16.335533127157916, -15.642370178936153, 
  -14.949191461572592, -14.255981201484294, -13.562707838173678, 
  -12.869308197260535, -12.175655715977504, -11.481496409007239, 
  -10.786318836216397, -10.089085990981232, -9.387665276274605, 
  -8.677538898523036, -7.948481042646202, -7.1725392959477325, 
  -6.050519272353644, -3.6642468136949233, -1.8890862252956793, 
  -0.9522551210979497, -0.4775961268028841, -0.23912188579581622, 
  -0.11963717394520837, -0.05983709235567567, -0.029923105722777718, 
  -0.014962684533753684, -0.007481624166621717, -0.0037408824314741178, 
  -0.0018704587869635978, -0.0009352337843138273, -0.00046761798961800737, 
  -0.00023380926914350595, -0.00011690470315161532, -0.000058452368720186384, 
	    0., 0.}}
 ;
 
